% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_ik09.R
\name{bw_ik09}
\alias{bw_ik09}
\title{Imbens-Kalyanaraman 2009 Optimal Bandwidth Calculation}
\usage{
bw_ik09(X, Y, cutpoint = NULL, verbose = FALSE, kernel = "triangular")
}
\arguments{
\item{X}{A numeric vector containing the running variable.}

\item{Y}{A numeric vector containing the outcome variable.}

\item{cutpoint}{A numeric value containing the cutpoint at which assignment to the treatment is determined. The default is 0.}

\item{verbose}{A logical value indicating whether to print more information to the terminal. 
The default is \code{FALSE}.}

\item{kernel}{A string indicating which kernel to use. Options are \code{"triangular"} 
(default and recommended), \code{"rectangular"}, \code{"epanechnikov"}, \code{"quartic"}, 
\code{"triweight"}, \code{"tricube"}, and \code{"cosine"}.}
}
\value{
\code{ik_bw09} returns a numeric value specifying the optimal bandwidth.
}
\description{
\code{bw_ik09} calculates the Imbens-Kalyanaraman (2009) optimal bandwidth
for local linear regression in regression discontinuity designs.
It is based on the \code{IKbandwidth} function in the "rdd" package. 
This is an internal function and is typically not directly invoked by the user. 
It can be accessed using the triple colon, as in rddapp:::bw_ik09().
}
\references{
Imbens, G., Kalyanaraman, K. (2009). 
  Optimal bandwidth choice for the regression discontinuity estimator 
  (Working Paper No. 14726). National Bureau of Economic Research.
  \url{https://www.nber.org/papers/w14726}.

Drew Dimmery (2016). rdd: Regression Discontinuity Estimation. R package version 0.57. https://CRAN.R-project.org/package=rdd
}
