% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdav.R
\name{wd_connect}
\alias{wd_connect}
\title{Establishes a connection to a WebDAV server}
\usage{
wd_connect(url, username = ncl_username_from_url(url), password = NULL)
}
\arguments{
\item{url}{url of the WebDAV directory}

\item{username}{username - if not given, it will be derived from the url}

\item{password}{password - if not given, you will be asked for it}
}
\value{
a httr2 request to the WebDAV server location
}
\description{
Creates and authenticate a request handle to the WebDAV server
}
\details{
Notice: it's not recommended to write the password as plain text. Either omit
the parameter (then you will be asked to enter a password interactively)
or use for example the system credential store via keyring package.
}
\examples{
\dontrun{
# establish a connection, you will be asked for a password

r <- wd_connect("https://example.com/remote.php/dav/files/myname","myname")


# establish a connection, use keyring package to retrieve the password

keyring::key_set("dav", "myname") # call only once

r <- wd_connect("https://example.com/remote.php/dav/files/myname",
                "myname",
                keyring::key_get("dav", "myname"))
}
}
