% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_forecast.R
\name{ts_forecast}
\alias{ts_forecast}
\title{Time Series Forecast for Daily Crime Data}
\usage{
ts_forecast(data)
}
\arguments{
\item{data}{Data frame of crime or RMS data. See provided Chicago Data Portal
example for reference}
}
\value{
Returns a plot which contains: the time series, a fitted confidence
    interval, the projected forecast, and the confidence interval for that
    forcast.
}
\description{
This function transforms traditional crime data for forecasting
    using the \pkg{prophet} procedure for forecasting time series data with
    an additive model where non-linear trends are fit with yearly, weekly,
    and daily seasonality. The function generates the forecast for a one
    year period with a confidence interval based on historical crime data.
}
\examples{
\dontshow{
data(crimes)
crimes <- head(crimes, n = 100) #truncate dataset for tests
library(prophet)
ts_forecast(crimes)}
\donttest{
#Using provided dataset from Chicago Data Portal:
data(crimes)
library(prophet)
ts_forecast(crimes)}
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{ts}
