% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_repeat.R
\name{id_repeat}
\alias{id_repeat}
\title{Identify Repeat Crime Incidents}
\usage{
id_repeat(data)
}
\arguments{
\item{data}{Data frame of crime or RMS data. See provided Chicago Data Portal
example for reference}
}
\value{
A list where each data frame contains repeat crime incidents for a
    given location.
}
\description{
This function identifies crime incidents which occur at the same
    location and returns a list of such incidents where each data frame in
    the list contains the RMS data for the repeat crime incidents. The data
    is based on the Chicago Police Department RMS structure.
}
\examples{
#Using provided dataset from Chicago Data Portal:
data(crimes)
crimes <- head(crimes, n = 1000)
out <- id_repeat(crimes)
}
\author{
Jamie Spaulding, Keith Morris
}
\keyword{dynamic}
\keyword{hplot}
\keyword{methods}
\keyword{spatial}
