% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDataFrameGenerics.R
\name{geoArea.CMBDataFrame}
\alias{geoArea.CMBDataFrame}
\title{Geodesic area covered by a \code{\link{CMBDataFrame}}}
\usage{
\method{geoArea}{CMBDataFrame}(x)
}
\arguments{
\item{x}{a CMBDataFrame.}
}
\value{
The sum of the areas of all pixels (rows) in x.
}
\description{
Gives the surface on the unit sphere
that is encompassed by all pixels in \code{cmbdf}
}
\examples{

## At low resolution, a few data points can
## occupy a large pixel area, e.g.:

cmbdf <- CMBDataFrame(nside = 1, spix = c(1,2,3))
pix(cmbdf)

## The total number of Healpix points at nside=1 equals 12. As cmbdf has 3 Healpix
## it occupies pi = 1/4*(surface area of unit sphere)

geoArea(cmbdf)
plot(cmbdf, size = 5, hp.boundaries = 1)

}
