% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_articles_pdf.R
\name{core_articles_pdf}
\alias{core_articles_pdf}
\alias{core_articles_pdf_}
\title{Download article pdf}
\usage{
core_articles_pdf(id, key = NULL, overwrite = FALSE, ...)

core_articles_pdf_(id, key = NULL, overwrite = FALSE, ...)
}
\arguments{
\item{id}{(integer) CORE ID of the article that needs to be fetched.
One or more. Required}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{overwrite}{(logical) overwrite file or not if already
on disk. Default: \code{FALSE}}

\item{...}{Curl options passed to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
\code{core_articles_pdf_} returns a file path on success.
When many IDs passed to \code{core_articles_pdf} it returns a list (equal to
length of IDs) where each element is a character vector of length equal
to number of pages in the PDF; but on failure throws warning and returns
NULL. When single ID apssed to \code{core_articles_pdf} it returns a character
vector of length equal to number of pages in the PDF, but on failure
stops with message
}
\description{
Download article pdf
}
\details{
\code{core_articles_pdf} does the HTTP request and parses
PDF to text, while \code{core_articles_pdf_} just does the HTTP request
and gives back the path to the file

If you get a message like \code{Error: Not Found (HTTP 404)}, that means
a PDF was not found. That is, it does not exist. That is, there is no
PDF associated with the article ID you searched for. This is the
correct behavior, and nothing is wrong with this function or this
package. We could do another web request to check if the id you
pass in has a PDF or not first, but that's another request, slowing
this function down.
}
\examples{
\dontrun{
# just http request, get file path back
core_articles_pdf_(11549557)

# get paper and parse to text
core_articles_pdf(11549557)

ids <- c(11549557, 385071)
res <- core_articles_pdf(ids)
cat(res[[1]][1])
cat(res[[2]][1])
}
}
\references{
\url{https://core.ac.uk/docs/#!/articles/getArticlePdfByCoreId}
}
