% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nominalSymmetryTest.r
\name{nominalSymmetryTest}
\alias{nominalSymmetryTest}
\title{Exact and McNemar symmetry tests for paired contingency tables}
\usage{
nominalSymmetryTest(x, method = "fdr", digits = 3, exact = FALSE, ...)
}
\arguments{
\item{x}{A two-way contingency table. It must be square. 
It can have two or
more levels for each dimension.}

\item{method}{The method to adjust multiple p-values. 
See \code{stats::p.adjust}.}

\item{digits}{The number of significant digits in the output.}

\item{exact}{If \code{TRUE}, uses the \code{binom.test} function.
If \code{FALSE}, uses the \code{mcnemar.test} function.}

\item{...}{Additional arguments}
}
\value{
A list containing: a data frame of results of the global test;
        a data frame of results of the pairwise results;
        and a data frame mentioning the p-value adjustment method.
}
\description{
Conducts an omnibus symmetry test for a paired 
             contingency table and then post-hoc pairwise tests.  
             This is similar to  
             McNemar and McNemar-Bowker tests in use.
}
\details{
The omnibus McNemar test
         may fail when there are zeros in critical
         cells.
         
         Currently, the \code{exact=TRUE} with a table greater
         than 2 x 2 will not produce an omnibus test result.
}
\examples{
### 2 x 2 repeated matrix example
data(AndersonRainBarrel)
nominalSymmetryTest(AndersonRainBarrel)
                    
### 3 x 3 repeated matrix example
data(AndersonRainGarden)
nominalSymmetryTest(AndersonRainGarden,
                    exact = FALSE)
                                                              
}
\references{
\url{http://rcompanion.org/handbook/H_05.html}
}
\seealso{
\code{\link{pairwiseMcnemar}}, 
         \code{\link{groupwiseCMH}},
         \code{\link{pairwiseNominalIndependence}}, 
         \code{\link{pairwiseNominalMatrix}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{McNemar Bowker}
\concept{McNemar's test}
\concept{post-hoc}
