% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cateNelsonFixedY.r
\name{cateNelsonFixedY}
\alias{cateNelsonFixedY}
\title{Cate-Nelson models for bivariate data with a fixed critical Y value}
\usage{
cateNelsonFixedY(
  x,
  y,
  cly = 0.95,
  plotit = TRUE,
  hollow = TRUE,
  xlab = "X",
  ylab = "Y",
  trend = "positive",
  clx = 1,
  outlength = 20,
  sortstat = "error"
)
}
\arguments{
\item{x}{A vector of values for the x variable.}

\item{y}{A vector of values for the y variable.}

\item{cly}{= Critical Y value.}

\item{plotit}{If \code{TRUE}, produces plots of the output.}

\item{hollow}{If \code{TRUE}, uses hollow circles on the plot to indicate
data not fitting the model.}

\item{xlab}{The label for the x-axis.}

\item{ylab}{The label for the y-axis.}

\item{trend}{\code{"postive"} if the trend of y vs. x is generally
positive. \code{"negative"} if negative.}

\item{clx}{Indicates which of the listed critical x values 
should be chosen as the critical x value for the plot.}

\item{outlength}{Indicates the number of potential critical x values
to display in the output.}

\item{sortstat}{The statistic to sort by.  Any of \code{"error"} 
(the default),
\code{"phi"}, \code{"fisher"}, or \code{"pearson"}.}
}
\value{
A data frame of statistics from the analysis:
        critical level for x, critical value for y, the
        number of observations in each of the quadrants (I, II, III, IV),
        the number of observations that conform with the model, 
        the number of observations that do not conform to the model,
        the proportion of observations that conform with the model,
        the proportion of observations that do not conform to the model,
        a p-value for the Fisher exact test for the data divided into
        the groups indicated by the model,
        phi for the data divided into
        the groups indicated by the model,
        and Pearson's chi-square for the data divided into
        the groups indicated by the model.
}
\description{
Produces critical-x values for bivariate data
             according to a Cate-Nelson analysis
             for a given critical Y value.
}
\details{
Cate-Nelson analysis divides bivariate data into two groups.
          For data with a positive trend, one group has a
          large \code{x} value associated with a large \code{y} value, and   
          the other group has a small \code{x} value associated with a small   
          \code{y} value. For a negative trend, a small \code{x} is
          associated with a large \code{y}, and so on. 
          
          The analysis is useful for bivariate data which don't conform well
          to linear, curvilinear, or plateau models.
}
\examples{
data(Nurseries)
cateNelsonFixedY(x          = Nurseries$Size,
                 y          = Nurseries$Proportion,
                 cly        = 0.70,
                 plotit     = TRUE,
                 hollow     = TRUE,
                 xlab       = "Nursery size in hectares",
                 ylab       = "Proportion of good practices adopted",
                 trend      = "positive",
                 clx        = 1,
                 outlength  = 15)

}
\references{
\url{http://rcompanion.org/rcompanion/h_02.html}
}
\seealso{
\code{\link{cateNelson}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Cate-Nelson}
\concept{agronomy}
