% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxonRG.r
\name{wilcoxonRG}
\alias{wilcoxonRG}
\title{Glass rank biserial correlation coefficient}
\usage{
wilcoxonRG(
  x,
  g = NULL,
  group = "row",
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  digits = 3,
  reportIncomplete = FALSE,
  verbose = FALSE,
  na.last = NA,
  ...
)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations.}

\item{g}{If \code{x} is a vector, \code{g} is the vector of observations for
the grouping, nominal variable.
Only the first two levels of the nominal variable are used.}

\item{group}{If \code{x} is a table or matrix, \code{group} indicates whether
the \code{"row"} or the \code{"column"} variable is
the nominal, grouping variable.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{reportIncomplete}{If \code{FALSE} (the default),
\code{NA} will be reported in cases where there
are instances of the calculation of the statistic
failing during the bootstrap procedure.}

\item{verbose}{If \code{TRUE}, prints information on factor levels and ranks.}

\item{na.last}{Passed to \code{rank}. For example, can be set to
\code{TRUE} to assign \code{NA} values a minimum rank.}

\item{...}{Additional arguments passed to \code{rank}}
}
\value{
A single statistic, rg.  
        Or a small data frame consisting of rg,
        and the lower and upper confidence limits.
}
\description{
Calculates Glass rank biserial correlation coefficient
             effect size
             for Mann-Whitney two-sample rank-sum test,
             or a table with an ordinal variable and a
             nominal variable with two levels; confidence intervals
             by bootstrap.
}
\details{
rg  is calculated as 2 times the difference of mean of ranks
          for each group divided by the total sample size.
          It appears that rg is equivalent to Cliff's delta.
 
          \code{NA} values can be handled by the \code{rank} function.
          In this case, using \code{verbose=TRUE} is helpful
          to understand how the \code{rg} statistic is calculated.
          Otherwise, it is recommended that \code{NA}s be removed
          beforehand.
          
          When the data in the first group are greater than
          in the second group, rg is positive.
          When the data in the second group are greater than
          in the first group, rg is negative.
          Be cautious with this interpretation, as R will alphabetize
          groups if \code{g} is not already a factor.
          
          When rg is close to extremes,
          or with small counts in some cells,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
data(Breakfast)
Table = Breakfast[1:2,]
library(coin)
chisq_test(Table, scores = list("Breakfast" = c(-2, -1, 0, 1, 2)))
wilcoxonRG(Table)

data(Catbus)
wilcox.test(Steps ~ Sex, data = Catbus)
wilcoxonRG(x = Catbus$Steps, g = Catbus$Sex)

### Example from King, Rosopa, and Minium
Criticism = c(-3, -2, 0, 0, 2, 5, 7, 9)
Praise = c(0, 2, 3, 4, 10, 12, 14, 19, 21)
Y = c(Criticism, Praise)
Group = factor(c(rep("Criticism", length(Criticism)),  
                rep("Praise", length(Praise))))
wilcoxonRG(x = Y, g = Group, verbose=TRUE)

}
\references{
King, B.M., P.J. Rosopa, and E.W. Minium. 2011. 
            Statistical Reasoning in the Behavioral Sciences, 6th ed.
}
\seealso{
\code{\link{wilcoxonR}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{correlation effect size ordinal nominal}
