% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwisePercentile.r
\name{groupwisePercentile}
\alias{groupwisePercentile}
\title{Groupwise percentiles and confidence intervals}
\usage{
groupwisePercentile(
  formula = NULL,
  data = NULL,
  var = NULL,
  group = NULL,
  conf = 0.95,
  tau = 0.5,
  type = 7,
  R = 5000,
  boot = FALSE,
  basic = FALSE,
  normal = FALSE,
  percentile = FALSE,
  bca = TRUE,
  digits = 3,
  ...
)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variables. e.g. y ~ x1 + x2.}

\item{data}{The data frame to use.}

\item{var}{If no formula is given, the measurement variable to use. 
The name is in double quotes.}

\item{group}{The grouping variable to use. The name is in double quotes.
Multiple names are listed as a vector. (See example.)}

\item{conf}{The confidence interval to use.}

\item{tau}{The percentile to use, expressed as a quantile,
e.g. 0.5 for median, 0.25 for 25th percentile.}

\item{type}{The \code{type} value passed to the \code{quantile} function}

\item{R}{The number of bootstrap replicates to use for bootstrapped
statistics.}

\item{boot}{If \code{TRUE}, includes the mean of the bootstrapped percentile.
This can be used as an estimate of the percentile for
the group.}

\item{basic}{If \code{TRUE}, includes the basic confidence
intervals for the group means by bootstrap.
See \code{\link{boot.ci}}.}

\item{normal}{If \code{TRUE}, includes the normal confidence
intervals for the group means by bootstrap.
See \code{\link{boot.ci}}.}

\item{percentile}{If \code{TRUE}, includes the percentile confidence
intervals for the group means by bootstrap.
See \code{\link{boot.ci}}.}

\item{bca}{If \code{TRUE}, includes the BCa confidence
intervals for the group means by bootstrap.
See \code{\link{boot.ci}}.}

\item{digits}{The number of significant figures to use in output.}

\item{...}{Other arguments passed to the \code{boot} function.}
}
\value{
A data frame of requested statistics by group
}
\description{
Calculates percentiles and confidence intervals for
             groups.
}
\details{
The input should include either \code{formula} and \code{data};
             or \code{data}, \code{var}, and \code{group}. (See examples).
          
         With some options, the function may not handle missing values well.
         This seems to happen particularly with \code{bca = TRUE}.
}
\note{
The parsing of the formula is simplistic. The first variable on the
         left side is used as the measurement variable.  The variables on the
         right side are used for the grouping variables.
         
       Results for ungrouped (one-sample) data can be obtained by either
         setting the right side of the formula to 1, e.g.  y ~ 1, or by
         setting \code{group=NULL}.
}
\examples{
### Example with formula notation
data(Catbus)
groupwisePercentile(Steps ~ Teacher + Sex,
                    data        = Catbus,
                    tau         = 0.25,
                    bca         = FALSE,
                    percentile  = TRUE,
                    R           = 1000)
                
### Example with variable notation
data(Catbus)
groupwisePercentile(data         = Catbus,
                    var         = "Steps",
                    group       = c("Teacher", "Sex"),
                    tau         = 0.25,
                    bca         = FALSE,
                    percentile  = TRUE,
                    R           = 1000)
                      
}
\references{
\url{http://rcompanion.org/handbook/F_15.html}
}
\seealso{
\code{\link{groupwiseMean}}, \code{\link{groupwiseHuber}}, 
         \code{\link{groupwiseGeometric}}, \code{\link{groupwiseMedian}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{percentile confidence interval bootstrap}
