% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epsilonSquared.r
\name{epsilonSquared}
\alias{epsilonSquared}
\title{Epsilon-squared}
\usage{
epsilonSquared(x, g = NULL, group = "row", digits = 3, ...)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations of an ordinal variable.}

\item{g}{If \code{x} is a vector, \code{g} is the vector of observations for
the grouping, nominal variable.}

\item{group}{If \code{x} is a table or matrix, \code{group} indicates whether
the \code{"row"} or the \code{"column"} variable is
the nominal, grouping variable.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{kruskal.test} function.}
}
\value{
A single statistic, epsilon-squared
}
\description{
Calculates epsilon-squared for a table with one ordinal
             variable and one nominal variable.
}
\details{
Epsilon-squared is used as a measure of association
          for the Kruskal-Wallis test or for a two-way
          table with one ordinal and one nominal variable.

          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
}
\examples{
data(Breakfast)
library(coin)
chisq_test(Breakfast, scores = list("Breakfast" = c(-2, -1, 0, 1, 2)))
epsilonSquared(Breakfast)

data(PoohPiglet)
kruskal.test(Likert ~ Speaker, data = PoohPiglet)
epsilonSquared(x = PoohPiglet$Likert, g = PoohPiglet$Speaker)

}
\references{
\url{http://rcompanion.org/handbook/H_11.html}
}
\seealso{
\code{\link{freemanTheta}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{
correlation epsilon ordinal nominal
}
