## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(rcoins)
library(sf)
library(ggplot2)

## -----------------------------------------------------------------------------
# Load streets from example OSM data
bucharest <- get_example_data()
streets <- bucharest$streets

## -----------------------------------------------------------------------------
# Trace continuous streets
continuous_streets <- stroke(streets)

## ----echo=FALSE---------------------------------------------------------------
length <- sf::st_length(continuous_streets)
ggplot() +
  geom_sf(data = continuous_streets, aes(linewidth = as.numeric(length))) +
  scale_linewidth_continuous(name = "Continuous lines", range = c(0.1, 1.2)) +
  xlim(418500, 437500) +
  ylim(4909800, 4931500) +
  coord_sf(datum = st_crs(32635)) +
  labs(title = "Continuous streets along the main street network of Bucharest",
       subtitle = "Lineweight by length",
       caption = "Data: OpenStreetMap")

## -----------------------------------------------------------------------------
# Load river centerline from example data
river_centerline <- bucharest$river_centerline

crossing_edges <- which(st_intersects(streets,
                                      river_centerline,
                                      sparse = FALSE))

# Trace continuous streets crossing the river
continuous_streets_crossing <- stroke(streets, from_edge = crossing_edges,
                                      angle_threshold = 120)

## ----echo=FALSE---------------------------------------------------------------
ggplot() +
  geom_sf(data = river_centerline, linewidth = 1, colour = "blue") +
  geom_sf(data = streets, linewidth = 0.2, colour = "black") +
  geom_sf(data = continuous_streets_crossing, linewidth = 2, colour = "red") +
  xlim(418500, 437500) +
  ylim(4909800, 4931500) +
  coord_sf(datum = st_crs(32635)) +
  labs(title = "Continuous streets crossing River Dâmbovița in Bucharest",
       subtitle = "Crossing streets thicker",
       caption = "Data: OpenStreetMap")

