% Generated by roxygen2 (4.0.2): do not edit by hand
\name{clinicaltrials_count}
\alias{clinicaltrials_count}
\title{Count number of results for a given search}
\usage{
clinicaltrials_count(query = NULL)
}
\arguments{
\item{query}{Search pattern as a string; a vector of key-value pairs is
  interpreted as an advanced search and is therefore combined with '&'}
}
\value{
Number of results (integer).
}
\description{
Count the number of results for a given search. Useful to check before
attempting to pull down a very large number of records.
}
\examples{
# count trials satisfying 'heart disease AND stroke AND California'
\dontrun{clinicaltrials_count(query = 'heart disease AND stroke AND California')}

# advanced search for open, interventional trials involving melanoma
\dontrun{clinicaltrials_count(query = c('recr=Open', 'type=Intr', 'cond=melanoma'))}
}

