% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ggchessboard.R
\name{ggchessboard}
\alias{ggchessboard}
\title{Plot a fen representation chessboard via ggplot2}
\usage{

  ggchessboard(fen = "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1",
  cellcols = c("#D2B48C", "#F5F5DC"), perspective = "white",
  piecesize = 15)
}
\arguments{
\item{fen}{Fen notation of a chessboard}

\item{cellcols}{A 2 length vector fot the cell colors}

\item{perspective}{A string to show the perspective (black, white)}

\item{piecesize}{Size of the the unicode texts}
}
\value{
A ggplot object
}
\description{
Function to show the fen string in ggplot2.
}
\examples{
ggchessboard()

ggchessboard(fen = "rnbqkbnr/pp1ppppp/8/2p5/4P3/8/PPPP1PPP/RNBQKBNR w KQkq c6 0 2")

ggchessboard(fen = "rnbqkbnr/pp1ppppp/8/2p5/4P3/8/PPPP1PPP/RNBQKBNR w KQkq c6 0 2",
             cellcols = c("#CCCCCC", "#FAFAFA"),
             piecesize = 17,
             perspective = "black")
}

