/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import org.openscience.cdk.Atom;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.pharmacophore.PharmacophoreAtom;
import org.openscience.cdk.smarts.SmartsPattern;

public class PharmacophoreQueryAtom
extends Atom
implements IQueryAtom {
    private final String smarts;
    private final SmartsPattern[] compiledSmarts;
    private String symbol;

    public PharmacophoreQueryAtom(String symbol, String smarts) {
        this.symbol = symbol;
        this.smarts = smarts;
        String[] subSmarts = smarts.split("\\|");
        this.compiledSmarts = new SmartsPattern[subSmarts.length];
        for (int i = 0; i < this.compiledSmarts.length; ++i) {
            this.compiledSmarts[i] = SmartsPattern.create((String)subSmarts[i]).setPrepare(false);
        }
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSmarts() {
        return this.smarts;
    }

    SmartsPattern[] getCompiledSmarts() {
        return this.compiledSmarts;
    }

    public boolean matches(IAtom atom) {
        PharmacophoreAtom patom = PharmacophoreAtom.get(atom);
        return patom.getSymbol().equals(this.getSymbol());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getSymbol()).append(" [").append(this.getSmarts()).append(']');
        return s.toString();
    }
}

