/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.graph.AllCycles;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.EdgeShortCycles;
import org.openscience.cdk.graph.EssentialCycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.InitialCycles;
import org.openscience.cdk.graph.MinimumCycleBasis;
import org.openscience.cdk.graph.RelevantCycles;
import org.openscience.cdk.graph.TripletShortCycles;
import org.openscience.cdk.graph.VertexShortCycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingSearch;

public final class Cycles {
    private final int[][] paths;
    private final IAtomContainer container;
    private final GraphUtil.EdgeToBondMap bondMap;

    private Cycles(int[][] paths, IAtomContainer container, GraphUtil.EdgeToBondMap bondMap) {
        this.paths = paths;
        this.container = container;
        this.bondMap = bondMap;
    }

    public int numberOfCycles() {
        return this.paths.length;
    }

    public int[][] paths() {
        int[][] cpy = new int[this.paths.length][];
        for (int i = 0; i < this.paths.length; ++i) {
            cpy[i] = (int[])this.paths[i].clone();
        }
        return cpy;
    }

    public IRingSet toRingSet() {
        return Cycles.toRingSet(this.container, this.paths, this.bondMap);
    }

    public static CycleFinder all() {
        return CycleComputation.ALL;
    }

    public static CycleFinder all(int length) {
        return new AllUpToLength(length);
    }

    public static CycleFinder mcb() {
        return CycleComputation.MCB;
    }

    public static CycleFinder relevant() {
        return CycleComputation.RELEVANT;
    }

    public static CycleFinder essential() {
        return CycleComputation.ESSENTIAL;
    }

    public static CycleFinder tripletShort() {
        return CycleComputation.TRIPLET_SHORT;
    }

    public static CycleFinder vertexShort() {
        return CycleComputation.VERTEX_SHORT;
    }

    public static CycleFinder edgeShort() {
        return CycleComputation.EDGE_SHORT;
    }

    public static CycleFinder cdkAromaticSet() {
        return CycleComputation.CDK_AROMATIC;
    }

    @Deprecated
    public static CycleFinder allOrVertexShort() {
        return Cycles.or(Cycles.all(), Cycles.vertexShort());
    }

    public static void smallRingSizes(IAtomContainer mol, int[] rsizes) {
        int acount = mol.getAtomCount();
        int marker = acount + 1;
        if (rsizes == null || acount > rsizes.length) {
            throw new IllegalArgumentException();
        }
        Arrays.fill(rsizes, 0, acount, marker);
        Cycles cycles = Cycles.vertexShort(mol);
        for (int[] path : cycles.paths()) {
            int rsize = path.length - 1;
            for (int v : path) {
                rsizes[v] = Math.min(rsize, rsizes[v]);
            }
        }
        for (int i = 0; i < acount; ++i) {
            if (rsizes[i] != marker) continue;
            rsizes[i] = 0;
        }
    }

    public static int smallRingSize(IAtom atom, int max) {
        if (!atom.isInRing()) {
            return 0;
        }
        IAtomContainer mol = atom.getContainer();
        int[] distTo = new int[mol.getAtomCount()];
        Arrays.fill(distTo, 1 + distTo.length);
        distTo[atom.getIndex()] = 0;
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        queue.add(atom);
        int smallest = 1 + distTo.length;
        while (!queue.isEmpty()) {
            IAtom a = (IAtom)queue.poll();
            int dist = 1 + distTo[a.getIndex()];
            for (IBond b : a.bonds()) {
                int tmp;
                if (!b.isInRing()) continue;
                IAtom nbr = b.getOther(a);
                if (dist < distTo[nbr.getIndex()]) {
                    distTo[nbr.getIndex()] = dist;
                    queue.add(nbr);
                    continue;
                }
                if (dist == 2 + distTo[nbr.getIndex()] || (tmp = dist + distTo[nbr.getIndex()]) >= smallest) continue;
                smallest = tmp;
            }
            if (2 * dist <= 1 + max) continue;
            break;
        }
        return smallest <= max ? smallest : 0;
    }

    public static int smallRingSize(IAtom atom) {
        return Cycles.smallRingSize(atom, atom.getContainer().getAtomCount());
    }

    public static int smallRingSize(IBond bond, int max) {
        if (!bond.isInRing()) {
            return 0;
        }
        IAtomContainer mol = bond.getContainer();
        int[] distTo = new int[mol.getAtomCount()];
        Arrays.fill(distTo, 1 + distTo.length);
        distTo[bond.getBegin().getIndex()] = 0;
        distTo[bond.getEnd().getIndex()] = 0;
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        queue.add(bond.getBegin());
        queue.add(bond.getEnd());
        int smallest = 1 + distTo.length;
        while (!queue.isEmpty()) {
            IAtom a = (IAtom)queue.poll();
            int dist = 1 + distTo[a.getIndex()];
            for (IBond b : a.bonds()) {
                int tmp;
                if (b == bond || !b.isInRing()) continue;
                IAtom nbr = b.getOther(a);
                if (dist < distTo[nbr.getIndex()]) {
                    distTo[nbr.getIndex()] = dist;
                    queue.add(nbr);
                    continue;
                }
                if (dist == 2 + distTo[nbr.getIndex()] || (tmp = 1 + dist + distTo[nbr.getIndex()]) >= smallest) continue;
                smallest = tmp;
            }
            if (2 * dist <= 1 + max) continue;
            break;
        }
        return smallest <= max ? smallest : 0;
    }

    public static int smallRingSize(IBond bond) {
        return Cycles.smallRingSize(bond, bond.getContainer().getAtomCount());
    }

    public static int markRingAtomsAndBonds(IAtomContainer mol) {
        GraphUtil.EdgeToBondMap bonds = GraphUtil.EdgeToBondMap.withSpaceFor(mol);
        return Cycles.markRingAtomsAndBonds(mol, GraphUtil.toAdjList(mol, bonds), bonds);
    }

    public static int markRingAtomsAndBonds(IAtomContainer mol, int[][] adjList, GraphUtil.EdgeToBondMap bondMap) {
        RingSearch ringSearch = new RingSearch(mol, adjList);
        for (int v = 0; v < mol.getAtomCount(); ++v) {
            mol.getAtom(v).setIsInRing(false);
            for (int w : adjList[v]) {
                if (v > w && ringSearch.cyclic(v, w)) {
                    bondMap.get(v, w).setIsInRing(true);
                    mol.getAtom(v).setIsInRing(true);
                    mol.getAtom(w).setIsInRing(true);
                    continue;
                }
                bondMap.get(v, w).setIsInRing(false);
            }
        }
        return ringSearch.numRings();
    }

    public static CycleFinder or(CycleFinder primary, CycleFinder auxiliary) {
        return new Fallback(primary, auxiliary);
    }

    public static Cycles all(IAtomContainer container) throws Intractable {
        return Cycles.all().find(container, container.getAtomCount());
    }

    public static Cycles all(IAtomContainer container, int length) throws Intractable {
        return Cycles.all().find(container, length);
    }

    public static Cycles mcb(IAtomContainer container) {
        return Cycles._invoke(Cycles.mcb(), container);
    }

    public static Cycles sssr(IAtomContainer container) {
        return Cycles.mcb(container);
    }

    public static Cycles relevant(IAtomContainer container) {
        return Cycles._invoke(Cycles.relevant(), container);
    }

    public static Cycles essential(IAtomContainer container) {
        return Cycles._invoke(Cycles.essential(), container);
    }

    public static Cycles tripletShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.tripletShort(), container);
    }

    public static Cycles vertexShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.vertexShort(), container);
    }

    public static Cycles edgeShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.edgeShort(), container);
    }

    public static CycleFinder unchorded(CycleFinder original) {
        return new Unchorded(original);
    }

    private static Cycles _invoke(CycleFinder finder, IAtomContainer container) {
        return Cycles._invoke(finder, container, container.getAtomCount());
    }

    private static Cycles _invoke(CycleFinder finder, IAtomContainer container, int length) {
        try {
            return finder.find(container, length);
        }
        catch (Intractable e) {
            throw new RuntimeException("Cycle computation should not be intractable: ", e);
        }
    }

    private static int[] lift(int[] path, int[] mapping) {
        for (int i = 0; i < path.length; ++i) {
            path[i] = mapping[path[i]];
        }
        return path;
    }

    private static IRingSet toRingSet(IAtomContainer container, int[][] cycles, GraphUtil.EdgeToBondMap bondMap) {
        IChemObjectBuilder builder = container.getBuilder();
        IRingSet rings = (IRingSet)builder.newInstance(IRingSet.class, new Object[0]);
        for (int[] cycle : cycles) {
            rings.addAtomContainer((IAtomContainer)Cycles.toRing(container, cycle, bondMap));
        }
        return rings;
    }

    private static IRing toRing(IAtomContainer container, int[] cycle, GraphUtil.EdgeToBondMap bondMap) {
        IAtom[] atoms = new IAtom[cycle.length - 1];
        IBond[] bonds = new IBond[cycle.length - 1];
        for (int i = 1; i < cycle.length; ++i) {
            int v = cycle[i];
            int u = cycle[i - 1];
            atoms[i - 1] = container.getAtom(u);
            bonds[i - 1] = Cycles.getBond(container, bondMap, u, v);
        }
        IChemObjectBuilder builder = container.getBuilder();
        IAtomContainer ring = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[]{0, 0, 0, 0});
        ring.setAtoms(atoms);
        ring.setBonds(bonds);
        return (IRing)builder.newInstance(IRing.class, new Object[]{ring});
    }

    private static IBond getBond(IAtomContainer container, GraphUtil.EdgeToBondMap bondMap, int u, int v) {
        if (bondMap != null) {
            return bondMap.get(u, v);
        }
        return container.getBond(container.getAtom(u), container.getAtom(v));
    }

    private static enum CycleComputation implements CycleFinder
    {
        MCB{

            @Override
            int[][] apply(int[][] graph, int length) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new MinimumCycleBasis(ic, true).paths();
            }
        }
        ,
        ESSENTIAL{

            @Override
            int[][] apply(int[][] graph, int length) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                RelevantCycles rc = new RelevantCycles(ic);
                return new EssentialCycles(rc, ic).paths();
            }
        }
        ,
        RELEVANT{

            @Override
            int[][] apply(int[][] graph, int length) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new RelevantCycles(ic).paths();
            }
        }
        ,
        ALL{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                int threshold = 3072;
                AllCycles ac = new AllCycles(graph, Math.min(length, graph.length), 3072);
                if (!ac.completed()) {
                    throw new Intractable("A large number of cycles were being generated and the computation was aborted. Please use AllCycles/AllRingsFinder with and specify a larger threshold or use a CycleFinder with a fall-back to a set unique cycles: e.g. Cycles.allOrVertexShort().");
                }
                return ac.paths();
            }
        }
        ,
        TRIPLET_SHORT{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new TripletShortCycles(new MinimumCycleBasis(ic, true), false).paths();
            }
        }
        ,
        VERTEX_SHORT{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new VertexShortCycles(ic).paths();
            }
        }
        ,
        EDGE_SHORT{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new EdgeShortCycles(ic).paths();
            }
        }
        ,
        CDK_AROMATIC{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                MinimumCycleBasis mcb = new MinimumCycleBasis(ic, true);
                if (mcb.size() > 3) {
                    return mcb.paths();
                }
                return ALL.apply(graph, length);
            }
        }
        ,
        ALL_OR_VERTEX_SHORT{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                int threshold = 3072;
                AllCycles ac = new AllCycles(graph, Math.min(length, graph.length), 3072);
                return ac.completed() ? ac.paths() : VERTEX_SHORT.apply(graph, length);
            }
        };


        abstract int[][] apply(int[][] var1, int var2) throws Intractable;

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            return this.find(molecule, molecule.getAtomCount());
        }

        @Override
        public Cycles find(IAtomContainer molecule, int length) throws Intractable {
            GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor(molecule);
            int[][] graph = GraphUtil.toAdjList(molecule, bondMap);
            RingSearch ringSearch = new RingSearch(molecule, graph);
            ArrayList<int[]> walks = new ArrayList<int[]>(6);
            for (int[] isolated : ringSearch.isolated()) {
                if (isolated.length > length) continue;
                walks.add(GraphUtil.cycle(graph, isolated));
            }
            for (int[] fused : ringSearch.fused()) {
                for (int[] cycle : this.apply(GraphUtil.subgraph(graph, fused), length)) {
                    walks.add(Cycles.lift(cycle, fused));
                }
            }
            return new Cycles((int[][])walks.toArray((T[])new int[walks.size()][0]), molecule, bondMap);
        }

        @Override
        public Cycles find(IAtomContainer molecule, int[][] graph, int length) throws Intractable {
            RingSearch ringSearch = new RingSearch(molecule, graph);
            ArrayList<int[]> walks = new ArrayList<int[]>(6);
            for (int[] isolated : ringSearch.isolated()) {
                walks.add(GraphUtil.cycle(graph, isolated));
            }
            for (int[] fused : ringSearch.fused()) {
                for (int[] cycle : this.apply(GraphUtil.subgraph(graph, fused), length)) {
                    walks.add(Cycles.lift(cycle, fused));
                }
            }
            return new Cycles((int[][])walks.toArray((T[])new int[walks.size()][0]), molecule, null);
        }
    }

    private static final class AllUpToLength
    implements CycleFinder {
        private final int predefinedLength;
        private final int threshold = 3072;

        private AllUpToLength(int length) {
            this.predefinedLength = length;
        }

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            return this.find(molecule, molecule.getAtomCount());
        }

        @Override
        public Cycles find(IAtomContainer molecule, int length) throws Intractable {
            return this.find(molecule, GraphUtil.toAdjList(molecule), length);
        }

        @Override
        public Cycles find(IAtomContainer molecule, int[][] graph, int length) throws Intractable {
            RingSearch ringSearch = new RingSearch(molecule, graph);
            if (this.predefinedLength < length) {
                length = this.predefinedLength;
            }
            ArrayList<int[]> walks = new ArrayList<int[]>(6);
            for (int[] isolated : ringSearch.isolated()) {
                if (isolated.length > length) continue;
                walks.add(GraphUtil.cycle(graph, isolated));
            }
            for (int[] fused : ringSearch.fused()) {
                for (int[] cycle : this.findInFused(GraphUtil.subgraph(graph, fused), length)) {
                    walks.add(Cycles.lift(cycle, fused));
                }
            }
            return new Cycles((int[][])walks.toArray((T[])new int[walks.size()][0]), molecule, null);
        }

        private int[][] findInFused(int[][] g, int length) throws Intractable {
            AllCycles allCycles = new AllCycles(g, Math.min(g.length, length), 3072);
            if (!allCycles.completed()) {
                throw new Intractable("A large number of cycles were being generated and the computation was aborted. Please us AllCycles/AllRingsFinder with and specify a larger threshold or an alternative cycle set.");
            }
            return allCycles.paths();
        }
    }

    private static final class Fallback
    implements CycleFinder {
        private final CycleFinder primary;
        private final CycleFinder auxiliary;

        private Fallback(CycleFinder primary, CycleFinder auxiliary) {
            this.primary = primary;
            this.auxiliary = auxiliary;
        }

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            return this.find(molecule, molecule.getAtomCount());
        }

        @Override
        public Cycles find(IAtomContainer molecule, int length) throws Intractable {
            return this.find(molecule, GraphUtil.toAdjList(molecule), length);
        }

        @Override
        public Cycles find(IAtomContainer molecule, int[][] graph, int length) throws Intractable {
            try {
                return this.primary.find(molecule, graph, length);
            }
            catch (Intractable e) {
                return this.auxiliary.find(molecule, graph, length);
            }
        }
    }

    private static final class Unchorded
    implements CycleFinder {
        private final CycleFinder primary;

        private Unchorded(CycleFinder primary) {
            this.primary = primary;
        }

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            return this.find(molecule, molecule.getAtomCount());
        }

        @Override
        public Cycles find(IAtomContainer molecule, int length) throws Intractable {
            return this.find(molecule, GraphUtil.toAdjList(molecule), length);
        }

        @Override
        public Cycles find(IAtomContainer molecule, int[][] graph, int length) throws Intractable {
            Cycles inital = this.primary.find(molecule, graph, length);
            int[][] filtered = new int[inital.numberOfCycles()][0];
            int n = 0;
            for (int[] path : inital.paths) {
                if (!this.accept(path, graph)) continue;
                filtered[n++] = path;
            }
            return new Cycles((int[][])Arrays.copyOf(filtered, n), inital.container, inital.bondMap);
        }

        private boolean accept(int[] path, int[][] graph) {
            BitSet vertices = new BitSet();
            for (int v : path) {
                vertices.set(v);
            }
            for (int j = 1; j < path.length; ++j) {
                int v = path[j];
                int prev = path[j - 1];
                int next = path[(j + 1) % (path.length - 1)];
                for (int w : graph[v]) {
                    if (w == prev || w == next || !vertices.get(w)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

