/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;

public class AverageBondLengthCalculator {
    public static double calculateAverageBondLength(IReaction reaction) {
        IAtomContainerSet reactants = reaction.getReactants();
        double reactantAverage = 0.0;
        if (reactants != null) {
            reactantAverage = AverageBondLengthCalculator.calculateAverageBondLength(reactants) / (double)reactants.getAtomContainerCount();
        }
        IAtomContainerSet products = reaction.getProducts();
        double productAverage = 0.0;
        if (products != null) {
            productAverage = AverageBondLengthCalculator.calculateAverageBondLength(products) / (double)products.getAtomContainerCount();
        }
        if (productAverage == 0.0 && reactantAverage == 0.0) {
            return 1.0;
        }
        return (productAverage + reactantAverage) / 2.0;
    }

    public static double calculateAverageBondLength(IAtomContainerSet moleculeSet) {
        double averageBondModelLength = 0.0;
        for (IAtomContainer atomContainer : moleculeSet.atomContainers()) {
            averageBondModelLength += GeometryTools.getBondLengthAverage((IAtomContainer)atomContainer);
        }
        return averageBondModelLength / (double)moleculeSet.getAtomContainerCount();
    }

    public static double calculateAverageBondLength(IChemModel model) {
        IAtomContainerSet moleculeSet = model.getMoleculeSet();
        if (moleculeSet == null) {
            IReactionSet reactionSet = model.getReactionSet();
            if (reactionSet != null) {
                return AverageBondLengthCalculator.calculateAverageBondLength(reactionSet);
            }
            return 0.0;
        }
        return AverageBondLengthCalculator.calculateAverageBondLength(moleculeSet);
    }

    public static double calculateAverageBondLength(IReactionSet reactionSet) {
        double averageBondModelLength = 0.0;
        for (IReaction reaction : reactionSet.reactions()) {
            averageBondModelLength += AverageBondLengthCalculator.calculateAverageBondLength(reaction);
        }
        return averageBondModelLength / (double)reactionSet.getReactionCount();
    }
}

