/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public abstract class AbstractRenderer<T extends IChemObject> {
    protected final RendererModel rendererModel;
    protected IFontManager fontManager;
    protected Point2d modelCenter = new Point2d(0.0, 0.0);
    protected Point2d drawCenter = new Point2d(150.0, 200.0);
    protected List<IGenerator<T>> generators;
    protected IRenderingElement cachedDiagram;
    protected AffineTransform transform;

    public AbstractRenderer(RendererModel rendererModel) {
        this.rendererModel = rendererModel;
    }

    public IRenderingElement generateDiagram(T object) {
        ElementGroup diagram = new ElementGroup();
        for (IGenerator<T> generator : this.generators) {
            diagram.add(generator.generate(object, this.rendererModel));
        }
        return diagram;
    }

    public abstract double calculateScaleForBondLength(double var1);

    public Rectangle calculateScreenBounds(Rectangle2D modelBounds) {
        double scale = (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double zoom = (Double)this.rendererModel.getParameter(BasicSceneGenerator.ZoomFactor.class).getValue();
        double margin = (Double)this.rendererModel.getParameter(BasicSceneGenerator.Margin.class).getValue();
        Point2d modelScreenCenter = this.toScreenCoordinates(modelBounds.getCenterX(), modelBounds.getCenterY());
        double width = scale * zoom * modelBounds.getWidth() + 2.0 * margin;
        double height = scale * zoom * modelBounds.getHeight() + 2.0 * margin;
        return new Rectangle((int)(modelScreenCenter.x - width / 2.0), (int)(modelScreenCenter.y - height / 2.0), (int)width, (int)height);
    }

    public Point2d toModelCoordinates(double screenX, double screenY) {
        try {
            double[] dest = new double[2];
            double[] src = new double[]{screenX, screenY};
            this.transform.inverseTransform(src, 0, dest, 0, 1);
            return new Point2d(dest[0], dest[1]);
        }
        catch (NoninvertibleTransformException n) {
            return new Point2d(0.0, 0.0);
        }
    }

    public Point2d toScreenCoordinates(double modelX, double modelY) {
        double[] dest = new double[2];
        this.transform.transform(new double[]{modelX, modelY}, 0, dest, 0, 1);
        return new Point2d(dest[0], dest[1]);
    }

    public void setModelCenter(double modelX, double modelY) {
        this.modelCenter = new Point2d(modelX, modelY);
        this.setup();
    }

    public void setDrawCenter(double modelX, double modelY) {
        this.drawCenter = new Point2d(modelX, modelY);
        this.setup();
    }

    public void setZoom(double zoom) {
        this.rendererModel.getParameter(BasicSceneGenerator.ZoomFactor.class).setValue(zoom);
        this.setup();
    }

    protected void setup() {
        double scale = (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double zoom = (Double)this.rendererModel.getParameter(BasicSceneGenerator.ZoomFactor.class).getValue();
        try {
            this.transform = new AffineTransform();
            this.transform.translate(this.drawCenter.x, this.drawCenter.y);
            this.transform.scale(1.0, -1.0);
            this.transform.scale(scale, scale);
            this.transform.scale(zoom, zoom);
            this.transform.translate(-this.modelCenter.x, -this.modelCenter.y);
        }
        catch (NullPointerException npe) {
            String errorString = "null pointer when setting transform: drawCenter=%s scale=%s zoom=%s modelCenter=%s";
            System.err.println(String.format(errorString, this.drawCenter, scale, zoom, this.modelCenter));
        }
    }

    public RendererModel getRenderer2DModel() {
        return this.rendererModel;
    }

    public void shiftDrawCenter(double shiftX, double shiftY) {
        this.drawCenter.set(this.drawCenter.x + shiftX, this.drawCenter.y + shiftY);
        this.setup();
    }

    public Point2d getDrawCenter() {
        return this.drawCenter;
    }

    public Point2d getModelCenter() {
        return this.modelCenter;
    }

    public void setZoomToFit(double drawWidth, double drawHeight, double diagramWidth, double diagramHeight) {
        double margin = (Double)this.rendererModel.getParameter(BasicSceneGenerator.Margin.class).getValue();
        double widthRatio = drawWidth / (diagramWidth + 2.0 * margin);
        double heightRatio = drawHeight / (diagramHeight + 2.0 * margin);
        double zoom = Math.min(widthRatio, heightRatio);
        this.fontManager.setFontForZoom(zoom);
        this.rendererModel.getParameter(BasicSceneGenerator.ZoomFactor.class).setValue(zoom);
    }

    public void repaint(IDrawVisitor drawVisitor) {
        this.paint(drawVisitor, this.cachedDiagram);
    }

    protected void paint(IDrawVisitor drawVisitor, IRenderingElement diagram) {
        if (diagram == null) {
            return;
        }
        this.cachedDiagram = diagram;
        this.fontManager.setFontName((String)this.rendererModel.getParameter(BasicSceneGenerator.FontName.class).getValue());
        this.fontManager.setFontStyle((IFontManager.FontStyle)((Object)this.rendererModel.getParameter(BasicSceneGenerator.UsedFontStyle.class).getValue()));
        drawVisitor.setFontManager(this.fontManager);
        drawVisitor.setTransform(this.transform);
        drawVisitor.setRendererModel(this.rendererModel);
        diagram.accept(drawVisitor);
    }

    protected void setupTransformNatural(Rectangle2D modelBounds) {
        double zoom = (Double)this.rendererModel.getParameter(BasicSceneGenerator.ZoomFactor.class).getValue();
        this.fontManager.setFontForZoom(zoom);
        this.setup();
    }

    public Rectangle shift(Rectangle screenBounds, Rectangle diagramBounds) {
        int screenMaxX = screenBounds.x + screenBounds.width;
        int screenMaxY = screenBounds.y + screenBounds.height;
        int diagramMaxX = diagramBounds.x + diagramBounds.width;
        int diagramMaxY = diagramBounds.y + diagramBounds.height;
        int leftOverlap = screenBounds.x - diagramBounds.x;
        int rightOverlap = diagramMaxX - screenMaxX;
        int topOverlap = screenBounds.y - diagramBounds.y;
        int bottomOverlap = diagramMaxY - screenMaxY;
        int dx = 0;
        int dy = 0;
        int width = screenBounds.width;
        int height = screenBounds.height;
        if (leftOverlap > 0) {
            dx = leftOverlap;
        }
        if (rightOverlap > 0) {
            width += rightOverlap;
        }
        if (topOverlap > 0) {
            dy = topOverlap;
        }
        if (bottomOverlap > 0) {
            height += bottomOverlap;
        }
        if (dx != 0 || dy != 0) {
            this.shiftDrawCenter(dx, dy);
        }
        return new Rectangle(dx, dy, width, height);
    }

    protected Rectangle convertToDiagramBounds(Rectangle2D modelBounds) {
        double xCenter = modelBounds.getCenterX();
        double yCenter = modelBounds.getCenterY();
        double modelWidth = modelBounds.getWidth();
        double modelHeight = modelBounds.getHeight();
        double scale = (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double zoom = (Double)this.rendererModel.getParameter(BasicSceneGenerator.ZoomFactor.class).getValue();
        Point2d screenCoord = this.toScreenCoordinates(xCenter, yCenter);
        if (modelWidth == 0.0 && modelHeight == 0.0) {
            return new Rectangle((int)screenCoord.x, (int)screenCoord.y, 0, 0);
        }
        double margin = (Double)this.rendererModel.getParameter(BasicSceneGenerator.Margin.class).getValue();
        int width = (int)(scale * zoom * modelWidth + 2.0 * margin);
        int height = (int)(scale * zoom * modelHeight + 2.0 * margin);
        int xCoord = (int)(screenCoord.x - (double)(width / 2));
        int yCoord = (int)(screenCoord.y - (double)(height / 2));
        return new Rectangle(xCoord, yCoord, width, height);
    }

    void setupTransformToFit(Rectangle2D screenBounds, Rectangle2D modelBounds, boolean reset) {
        double scale = (Double)this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).getValue();
        if (screenBounds == null) {
            return;
        }
        this.setDrawCenter(screenBounds.getCenterX(), screenBounds.getCenterY());
        double drawWidth = screenBounds.getWidth();
        double drawHeight = screenBounds.getHeight();
        double diagramWidth = modelBounds.getWidth() * scale;
        double diagramHeight = modelBounds.getHeight() * scale;
        this.setZoomToFit(drawWidth, drawHeight, diagramWidth, diagramHeight);
        if (reset || ((Boolean)this.rendererModel.getParameter(BasicSceneGenerator.FitToScreen.class).getValue()).booleanValue()) {
            this.setModelCenter(modelBounds.getCenterX(), modelBounds.getCenterY());
        }
        this.setup();
    }

    protected void setupTransformToFit(Rectangle2D screenBounds, Rectangle2D modelBounds, double bondLength, boolean reset) {
        if (screenBounds == null) {
            return;
        }
        this.setDrawCenter(screenBounds.getCenterX(), screenBounds.getCenterY());
        double scale = this.calculateScaleForBondLength(bondLength);
        double drawWidth = screenBounds.getWidth();
        double drawHeight = screenBounds.getHeight();
        double diagramWidth = modelBounds.getWidth() * scale;
        double diagramHeight = modelBounds.getHeight() * scale;
        this.setZoomToFit(drawWidth, drawHeight, diagramWidth, diagramHeight);
        if (reset || ((Boolean)this.rendererModel.getParameter(BasicSceneGenerator.FitToScreen.class).getValue()).booleanValue()) {
            this.setModelCenter(modelBounds.getCenterX(), modelBounds.getCenterY());
        }
        this.rendererModel.getParameter(BasicSceneGenerator.Scale.class).setValue(scale);
        this.setup();
    }

    public Rectangle2D getBounds(IRenderingElement element) {
        if (element == null) {
            return null;
        }
        double minX = 2.147483647E9;
        double minY = 2.147483647E9;
        double maxX = -2.147483648E9;
        double maxY = -2.147483648E9;
        if (element instanceof ElementGroup) {
            for (IRenderingElement child : (ElementGroup)element) {
                Rectangle2D bounds = this.getBounds(child);
                if (bounds == null) continue;
                if (bounds.getMinX() < minX) {
                    minX = bounds.getMinX();
                }
                if (bounds.getMinY() < minY) {
                    minY = bounds.getMinY();
                }
                if (bounds.getMaxX() > maxX) {
                    maxX = bounds.getMaxX();
                }
                if (!(bounds.getMaxY() > maxY)) continue;
                maxY = bounds.getMaxY();
            }
        } else if (element.getClass().equals(Bounds.class)) {
            Bounds bounds = (Bounds)element;
            if (bounds.minX < minX) {
                minX = bounds.minX;
            }
            if (bounds.minY < minY) {
                minY = bounds.minY;
            }
            if (bounds.maxX > maxX) {
                maxX = bounds.maxX;
            }
            if (bounds.maxY > maxY) {
                maxY = bounds.maxY;
            }
        }
        if (minX == 2.147483647E9) {
            return null;
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }
}

