/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleInfGraph;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class BasicFBReifier
implements Reifier {
    protected final GetReifier deductions;
    protected final Graph parent;
    protected final Reifier base;

    public BasicFBReifier(BasicForwardRuleInfGraph parent, Reifier base, GetReifier deductions, ReificationStyle style) {
        this.deductions = deductions;
        this.parent = parent;
        this.base = base;
    }

    @Override
    public ExtendedIterator<Node> allNodes() {
        return this.base.allNodes().andThen(this.deductions.getReifier().allNodes());
    }

    @Override
    public ExtendedIterator<Node> allNodes(Triple t) {
        return this.base.allNodes(t).andThen(this.deductions.getReifier().allNodes());
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m) {
        return this.base.find(m).andThen(this.deductions.getReifier().find(m));
    }

    @Override
    public ExtendedIterator<Triple> findEither(TripleMatch m, boolean showHidden) {
        return this.base.findEither(m, showHidden).andThen(this.deductions.getReifier().findEither(m, showHidden));
    }

    @Override
    public ExtendedIterator<Triple> findExposed(TripleMatch m) {
        return this.base.findExposed(m).andThen(this.deductions.getReifier().findExposed(m));
    }

    @Override
    public Graph getParentGraph() {
        return this.parent;
    }

    @Override
    public ReificationStyle getStyle() {
        return this.base.getStyle();
    }

    @Override
    public boolean handledAdd(Triple t) {
        return this.base.handledAdd(t);
    }

    @Override
    public boolean handledRemove(Triple t) {
        return this.base.handledRemove(t);
    }

    @Override
    public boolean hasTriple(Node n) {
        return this.base.hasTriple(n) || this.deductions.getReifier().hasTriple(n);
    }

    @Override
    public boolean hasTriple(Triple t) {
        return this.base.hasTriple(t) || this.deductions.getReifier().hasTriple(t);
    }

    @Override
    public Node reifyAs(Node n, Triple t) {
        return this.base.reifyAs(n, t);
    }

    @Override
    public void remove(Node n, Triple t) {
        this.base.remove(n, t);
    }

    @Override
    public void remove(Triple t) {
        this.base.remove(t);
    }

    @Override
    public int size() {
        return this.deductions.getReifier().size();
    }

    @Override
    public Triple getTriple(Node n) {
        Triple a = this.base.getTriple(n);
        Triple b = this.deductions.getReifier().getTriple(n);
        if (a != null && b != null) {
            throw new JenaException("TODO: have multiple answers for getTrple, viz " + a + " and " + b);
        }
        return a == null ? b : a;
    }

    static interface GetReifier {
        public Reifier getReifier();
    }
}

