/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.util.Arrays;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.TetrahedralChirality;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Element;
import uk.ac.ebi.beam.Graph;

@TestClass(value="org.openscience.cdk.smiles.BeamToCDKTest")
final class BeamToCDK {
    private final IChemObjectBuilder builder;
    private final IAtom templateAtom;
    private final IBond templateBond;
    private final IAtomContainer emptyContainer;

    BeamToCDK(IChemObjectBuilder builder) {
        this.builder = builder;
        this.templateAtom = builder.newInstance(IAtom.class, new Object[0]);
        this.templateBond = builder.newInstance(IBond.class, new Object[0]);
        this.emptyContainer = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
    }

    @TestMethod(value="benzene,imidazole")
    IAtomContainer toAtomContainer(Graph g) {
        IAtomContainer ac = this.emptyContainer();
        IAtom[] atoms = new IAtom[g.order()];
        IBond[] bonds = new IBond[g.size()];
        int j = 0;
        for (int i = 0; i < g.order(); ++i) {
            atoms[i] = this.toCDKAtom(g.atom(i), g.implHCount(i));
        }
        for (Edge e : g.edges()) {
            bonds[j++] = this.toCDKBond(e, atoms);
        }
        for (int u = 0; u < g.order(); ++u) {
            IStereoElement se;
            Configuration c = g.configurationOf(u);
            if (c.type() != Configuration.Type.Tetrahedral || (se = this.newTetrahedral(u, g.neighbors(u), atoms, c)) == null) continue;
            ac.addStereoElement(se);
        }
        ac.setAtoms(atoms);
        ac.setBonds(bonds);
        this.addDoubleBondStereochemistry(g, ac);
        return ac;
    }

    private void addDoubleBondStereochemistry(Graph g, IAtomContainer ac) {
        for (Edge e : g.edges()) {
            if (e.bond() != Bond.DOUBLE) continue;
            int u = e.either();
            int v = e.other(u);
            Edge first = this.findDirectionalEdge(g, u);
            Edge second = this.findDirectionalEdge(g, v);
            if (first == null || second == null) continue;
            IDoubleBondStereochemistry.Conformation conformation = first.bond(u) == second.bond(v) ? IDoubleBondStereochemistry.Conformation.TOGETHER : IDoubleBondStereochemistry.Conformation.OPPOSITE;
            IBond db = ac.getBond(ac.getAtom(u), ac.getAtom(v));
            IBond[] ligands = new IBond[]{ac.getBond(ac.getAtom(u), ac.getAtom(first.other(u))), ac.getBond(ac.getAtom(v), ac.getAtom(second.other(v)))};
            ac.addStereoElement(new DoubleBondStereochemistry(db, ligands, conformation));
        }
    }

    private Edge findDirectionalEdge(Graph g, int u) {
        for (Edge e : g.edges(u)) {
            Bond b = e.bond();
            if (b != Bond.UP && b != Bond.DOWN) continue;
            return e;
        }
        return null;
    }

    private IStereoElement newTetrahedral(int u, int[] vs, IAtom[] atoms, Configuration c) {
        if (vs.length != 4) {
            if (vs.length != 3) {
                return null;
            }
            vs = BeamToCDK.insert(u, vs);
        }
        ITetrahedralChirality.Stereo stereo = c == Configuration.TH1 ? ITetrahedralChirality.Stereo.ANTI_CLOCKWISE : ITetrahedralChirality.Stereo.CLOCKWISE;
        return new TetrahedralChirality(atoms[u], new IAtom[]{atoms[vs[0]], atoms[vs[1]], atoms[vs[2]], atoms[vs[3]]}, stereo);
    }

    private static int[] insert(int v, int[] vs) {
        int n = vs.length;
        int[] ws = Arrays.copyOf(vs, n + 1);
        ws[n] = v;
        for (int i = n; i > 0 && ws[i] < ws[i - 1]; --i) {
            int tmp = ws[i];
            ws[i] = ws[i - 1];
            ws[i - 1] = tmp;
        }
        return ws;
    }

    @TestMethod(value="methaneAtom,waterAtom,oxidanide,azaniumAtom")
    IAtom toCDKAtom(Atom beamAtom, int hCount) {
        IAtom cdkAtom = this.newCDKAtom(beamAtom);
        cdkAtom.setImplicitHydrogenCount(hCount);
        cdkAtom.setFormalCharge(beamAtom.charge());
        if (beamAtom.isotope() >= 0) {
            cdkAtom.setMassNumber(beamAtom.isotope());
        }
        if (beamAtom.aromatic()) {
            cdkAtom.setFlag(32, true);
        }
        return cdkAtom;
    }

    @TestMethod(value="newUnknownAtom,newCarbonAtom,newNitrogenAtom")
    IAtom newCDKAtom(Atom atom) {
        Element element = atom.element();
        boolean unknown = element == Element.Unknown;
        return unknown ? (IAtom)this.builder.newInstance(IPseudoAtom.class, element.symbol()) : this.createAtom(element);
    }

    @TestMethod(value="singleBondEdge,aromaticBondEdge,doubleBondEdge")
    IBond toCDKBond(Edge edge, IAtom[] atoms) {
        int u = edge.either();
        int v = edge.other(u);
        IBond bond = this.createBond(atoms[u], atoms[v], this.toCDKBondOrder(edge));
        if (edge.bond() == Bond.AROMATIC || edge.bond() == Bond.IMPLICIT && atoms[u].getFlag(32) && atoms[v].getFlag(32)) {
            bond.setFlag(32, true);
            atoms[u].setFlag(32, true);
            atoms[v].setFlag(32, true);
        }
        return bond;
    }

    private IBond.Order toCDKBondOrder(Edge edge) {
        switch (edge.bond()) {
            case SINGLE: 
            case UP: 
            case DOWN: 
            case IMPLICIT: 
            case AROMATIC: {
                return IBond.Order.SINGLE;
            }
            case DOUBLE: {
                return IBond.Order.DOUBLE;
            }
            case TRIPLE: {
                return IBond.Order.TRIPLE;
            }
            case QUADRUPLE: {
                return IBond.Order.QUADRUPLE;
            }
        }
        throw new IllegalArgumentException("Edge label " + (Object)((Object)edge.bond()) + "cannot be converted to a CDK bond order");
    }

    private IAtomContainer emptyContainer() {
        try {
            return this.emptyContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        }
    }

    private IAtom createAtom(Element element) {
        try {
            IAtom atom = (IAtom)this.templateAtom.clone();
            atom.setSymbol(element.symbol());
            atom.setAtomicNumber(element.atomicNumber());
            return atom;
        }
        catch (CloneNotSupportedException e) {
            return this.builder.newInstance(IAtom.class, element.symbol());
        }
    }

    private IBond createBond(IAtom either, IAtom other, IBond.Order order) {
        try {
            IBond bond = (IBond)this.templateBond.clone();
            bond.setAtoms(new IAtom[]{either, other});
            bond.setOrder(order);
            return bond;
        }
        catch (CloneNotSupportedException e) {
            return this.builder.newInstance(IBond.class, new Object[]{either, other, order});
        }
    }
}

