/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.silent.AtomContainerSet;
import org.openscience.cdk.silent.ChemObject;
import org.openscience.cdk.silent.Crystal;
import org.openscience.cdk.silent.RingSet;

public class ChemModel
extends ChemObject
implements Serializable,
IChemModel,
IChemObjectListener,
Cloneable {
    private static final long serialVersionUID = -5213425310451366185L;
    protected IAtomContainerSet setOfMolecules = null;
    protected IReactionSet setOfReactions = null;
    protected IRingSet ringSet = null;
    protected ICrystal crystal = null;

    public IAtomContainerSet getMoleculeSet() {
        return this.setOfMolecules;
    }

    public void setMoleculeSet(IAtomContainerSet setOfMolecules) {
        this.setOfMolecules = setOfMolecules;
    }

    public IRingSet getRingSet() {
        return this.ringSet;
    }

    public void setRingSet(IRingSet ringSet) {
        this.ringSet = ringSet;
    }

    public ICrystal getCrystal() {
        return this.crystal;
    }

    public void setCrystal(ICrystal crystal) {
        this.crystal = crystal;
    }

    public IReactionSet getReactionSet() {
        return this.setOfReactions;
    }

    public void setReactionSet(IReactionSet sor) {
        this.setOfReactions = sor;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("ChemModel(");
        buffer.append(this.hashCode());
        if (this.getMoleculeSet() != null) {
            buffer.append(", ");
            buffer.append(this.getMoleculeSet().toString());
        }
        if (this.getCrystal() != null) {
            buffer.append(", ");
            buffer.append(this.getCrystal().toString());
        }
        if (this.getReactionSet() != null) {
            buffer.append(", ");
            buffer.append(this.getReactionSet().toString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        ChemModel clone = (ChemModel)super.clone();
        clone.setOfMolecules = this.setOfMolecules != null ? (AtomContainerSet)this.setOfMolecules.clone() : null;
        clone.setOfReactions = this.setOfReactions != null ? (IReactionSet)this.setOfReactions.clone() : null;
        clone.crystal = this.crystal != null ? (Crystal)this.crystal.clone() : null;
        clone.ringSet = this.ringSet != null ? (RingSet)this.ringSet.clone() : null;
        return clone;
    }

    public void stateChanged(IChemObjectChangeEvent event) {
    }

    @TestMethod(value="testIsEmpty_MoleculeSet,testIsEmpty_RingSet,testIsEmpty_Crystal,testIsEmpty_ReactionSet")
    public boolean isEmpty() {
        if (this.setOfMolecules != null && !this.setOfMolecules.isEmpty()) {
            return false;
        }
        if (this.setOfReactions != null && !this.setOfReactions.isEmpty()) {
            return false;
        }
        if (this.ringSet != null && !this.ringSet.isEmpty()) {
            return false;
        }
        return this.crystal == null || this.crystal.isEmpty();
    }
}

