/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.LargestChainDescriptorTest")
public class LargestChainDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private boolean checkAromaticity = false;
    private boolean checkRingSystem = false;
    private static final String[] names = new String[]{"nAtomLC"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#largestChain", this.getClass().getName(), "$Id: 729985e482132aace854602e5e14f617c1889b95 $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 2) {
            throw new CDKException("LargestChainDescriptor only expects two parameter");
        }
        if (!(params[0] instanceof Boolean) || !(params[1] instanceof Boolean)) {
            throw new CDKException("Both parameters must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
        this.checkRingSystem = (Boolean)params[1];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity, this.checkRingSystem};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        int i;
        IAtomContainer container;
        try {
            container = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        boolean[] originalFlag4 = new boolean[container.getAtomCount()];
        for (int i2 = 0; i2 < originalFlag4.length; ++i2) {
            originalFlag4[i2] = container.getAtom(i2).getFlag(16);
        }
        if (this.checkRingSystem) {
            IRingSet rs;
            try {
                rs = new SpanningTree(container).getBasicRings();
            }
            catch (NoSuchAtomException e) {
                return this.getDummyDescriptorValue(e);
            }
            for (int i3 = 0; i3 < container.getAtomCount(); ++i3) {
                if (!rs.contains(container.getAtom(i3))) continue;
                container.getAtom(i3).setFlag(2, true);
            }
        }
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container);
                CDKHueckelAromaticityDetector.detectAromaticity(container);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        container = AtomContainerManipulator.removeHydrogens(container);
        int largestChainAtomsCount = 0;
        for (i = 0; i < container.getAtomCount(); ++i) {
            container.getAtom(i).setFlag(16, false);
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            IAtom atomi = container.getAtom(i);
            if (!((!atomi.getFlag(32) && !atomi.getFlag(2)) & !atomi.getFlag(16))) continue;
            ArrayList<IAtom> startSphere = new ArrayList<IAtom>();
            ArrayList<IAtom> path = new ArrayList<IAtom>();
            startSphere.add(atomi);
            try {
                this.breadthFirstSearch(container, startSphere, path);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
            if (path.size() <= largestChainAtomsCount) continue;
            largestChainAtomsCount = path.size();
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(largestChainAtomsCount), this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    private void breadthFirstSearch(IAtomContainer container, List<IAtom> sphere, List<IAtom> path) throws CDKException {
        ArrayList<IAtom> newSphere = new ArrayList<IAtom>();
        for (int i = 0; i < sphere.size(); ++i) {
            IAtom atom = sphere.get(i);
            List<IBond> bonds = container.getConnectedBondsList(atom);
            for (IBond bond : bonds) {
                IAtom nextAtom = bond.getConnectedAtom(atom);
                if ((!nextAtom.getFlag(32) && !nextAtom.getFlag(2)) & !nextAtom.getFlag(16)) {
                    path.add(nextAtom);
                    nextAtom.setFlag(16, true);
                    if (container.getConnectedBondsCount(nextAtom) <= 1) continue;
                    newSphere.add(nextAtom);
                    continue;
                }
                nextAtom.setFlag(16, true);
            }
        }
        if (newSphere.size() > 0) {
            this.breadthFirstSearch(container, newSphere, path);
        }
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity", "checkRingSystem"};
        return params;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return true;
    }
}

