/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fingerprint.FingerprinterTest")
public class Fingerprinter
implements IFingerprinter {
    public static final int DEFAULT_SIZE = 1024;
    public static final int DEFAULT_SEARCH_DEPTH = 8;
    private int size;
    private int searchDepth;
    static int debugCounter = 0;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Fingerprinter.class);
    private static final Map<String, String> queryReplace = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Cl", "X");
            this.put("Br", "Z");
            this.put("Si", "Y");
            this.put("As", "D");
            this.put("Li", "L");
            this.put("Se", "E");
            this.put("Na", "G");
            this.put("Ca", "J");
            this.put("Al", "A");
        }
    };

    public Fingerprinter() {
        this(1024, 8);
    }

    public Fingerprinter(int size) {
        this(size, 8);
    }

    public Fingerprinter(int size, int searchDepth) {
        this.size = size;
        this.searchDepth = searchDepth;
    }

    @TestMethod(value="testgetBitFingerprint_IAtomContainer")
    public IBitFingerprint getBitFingerprint(IAtomContainer container, AllRingsFinder ringFinder) throws CDKException {
        int[] hashes;
        int position = -1;
        logger.debug("Entering Fingerprinter");
        logger.debug("Starting Aromaticity Detection");
        long before = System.currentTimeMillis();
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container);
        CDKHueckelAromaticityDetector.detectAromaticity(container);
        long after = System.currentTimeMillis();
        logger.debug("time for aromaticity calculation: " + (after - before) + " milliseconds");
        logger.debug("Finished Aromaticity Detection");
        BitSet bitSet = new BitSet(this.size);
        for (int hash : hashes = this.findPathes(container, this.searchDepth)) {
            position = new Random(hash).nextInt(this.size);
            bitSet.set(position);
        }
        return new BitSetFingerprint(bitSet);
    }

    @Override
    @TestMethod(value="testgetBitFingerprint_IAtomContainer")
    public IBitFingerprint getBitFingerprint(IAtomContainer container) throws CDKException {
        return this.getBitFingerprint(container, null);
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    protected int[] findPathes(IAtomContainer container, int searchDepth) {
        ArrayList<StringBuffer> allPaths = new ArrayList<StringBuffer>();
        HashMap<IAtom, 2> cache = new HashMap<IAtom, 2>();
        for (IAtom startAtom : container.atoms()) {
            List<List<IAtom>> p = PathTools.getPathsOfLengthUpto(container, startAtom, searchDepth);
            for (List<IAtom> path : p) {
                StringBuffer sb = new StringBuffer();
                IAtom x = path.get(0);
                if (x instanceof IPseudoAtom) {
                    sb.append((char)PeriodicTable.getElementCount() + '\u0001');
                } else {
                    Integer atnum = PeriodicTable.getAtomicNumber(x.getSymbol());
                    if (atnum != null) {
                        sb.append(this.convertSymbol(x.getSymbol()));
                    } else {
                        sb.append((char)PeriodicTable.getElementCount() + '\u0001');
                    }
                }
                for (int i = 1; i < path.size(); ++i) {
                    final IAtom[] y = new IAtom[]{path.get(i)};
                    Map m = (Map)cache.get(x);
                    final IBond[] b = new IBond[]{m != null ? (IBond)m.get(y[0]) : null};
                    if (b[0] == null) {
                        b[0] = container.getBond(x, y[0]);
                        cache.put(x, new HashMap<IAtom, IBond>(){
                            {
                                this.put(y[0], b[0]);
                            }
                        });
                    }
                    sb.append(this.getBondSymbol(b[0]));
                    sb.append(this.convertSymbol(y[0].getSymbol()));
                    x = y[0];
                }
                StringBuffer revForm = new StringBuffer(sb);
                revForm.reverse();
                if (sb.toString().compareTo(revForm.toString()) <= 0) {
                    allPaths.add(sb);
                    continue;
                }
                allPaths.add(revForm);
            }
        }
        HashSet<String> cleanPath = new HashSet<String>();
        for (StringBuffer s : allPaths) {
            String s2;
            String s1 = s.toString().trim();
            if (s1.equals("") || cleanPath.contains(s1) || cleanPath.contains(s2 = s.reverse().toString().trim())) continue;
            cleanPath.add(s2);
        }
        int[] hashes = new int[cleanPath.size()];
        int i = 0;
        for (String s : cleanPath) {
            hashes[i++] = s.hashCode();
        }
        return hashes;
    }

    private String convertSymbol(String symbol) {
        String returnSymbol = queryReplace.get(symbol);
        return returnSymbol == null ? symbol : returnSymbol;
    }

    protected String getBondSymbol(IBond bond) {
        String bondSymbol = "";
        if (bond.getFlag(32)) {
            bondSymbol = ":";
        } else if (bond.getOrder() == IBond.Order.SINGLE) {
            bondSymbol = "-";
        } else if (bond.getOrder() == IBond.Order.DOUBLE) {
            bondSymbol = "=";
        } else if (bond.getOrder() == IBond.Order.TRIPLE) {
            bondSymbol = "#";
        }
        return bondSymbol;
    }

    @TestMethod(value="testGetSearchDepth")
    public int getSearchDepth() {
        return this.searchDepth;
    }

    @Override
    @TestMethod(value="testGetSize")
    public int getSize() {
        return this.size;
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }
}

