/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import nu.xom.TextWriter;

class GenericWriter
extends TextWriter {
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream(32);
    private final OutputStreamWriter wout;
    private final boolean isJapanese;

    GenericWriter(Writer out, String encoding) throws UnsupportedEncodingException {
        super(out, encoding);
        this.wout = new OutputStreamWriter((OutputStream)this.bout, encoding);
        encoding = encoding.toUpperCase(Locale.ENGLISH);
        this.isJapanese = encoding.indexOf("EUC-JP") > -1 || encoding.startsWith("EUC_JP") || encoding.equals("SHIFT_JIS") || encoding.equals("SJIS") || encoding.equals("ISO-2022-JP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needsEscaping(char c) {
        if (c <= '\u007f') {
            return false;
        }
        if (this.isJapanese) {
            if (c == '\u00a5') {
                return true;
            }
            if (c == '\u203e') {
                return true;
            }
        }
        boolean result = false;
        try {
            this.wout.write(c);
            this.wout.flush();
            byte[] data = this.bout.toByteArray();
            if (data.length == 0) {
                result = true;
            } else if (data[0] == 63) {
                result = true;
            } else if (this.isJapanese && data[0] == 33) {
                result = true;
            }
        }
        catch (IOException ex) {
            boolean bl = true;
            return bl;
        }
        catch (Error err) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.bout.reset();
        }
        return result;
    }
}

