/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.stereo.Projection;
import org.openscience.cdk.stereo.Stereocenters;
import org.openscience.cdk.stereo.TetrahedralChirality;

final class FischerRecognition {
    public static final double CARDINALITY_THRESHOLD = Math.toRadians(5.0);
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    private final IAtomContainer container;
    private final int[][] graph;
    private final GraphUtil.EdgeToBondMap bonds;
    private final Stereocenters stereocenters;

    FischerRecognition(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bonds, Stereocenters stereocenters) {
        this.container = container;
        this.graph = graph;
        this.bonds = bonds;
        this.stereocenters = stereocenters;
    }

    List<IStereoElement> recognise(Set<Projection> projections) {
        if (!projections.contains((Object)Projection.Fischer)) {
            return Collections.emptyList();
        }
        HashMap<IAtom, Integer> atomToIndex = new HashMap<IAtom, Integer>();
        for (IAtom atom : this.container.atoms()) {
            if (atom.getPoint2d() == null) {
                return Collections.emptyList();
            }
            atomToIndex.put(atom, atomToIndex.size());
        }
        RingSearch ringSearch = new RingSearch(this.container, this.graph);
        ArrayList<IStereoElement> elements = new ArrayList<IStereoElement>(5);
        for (int v = 0; v < this.container.getAtomCount(); ++v) {
            ITetrahedralChirality element;
            IAtom focus = this.container.getAtom(v);
            Elements elem = Elements.ofNumber(focus.getAtomicNumber());
            if (elem != Elements.Carbon || ringSearch.cyclic(v) || this.stereocenters.elementType(v) != Stereocenters.Type.Tetracoordinate || !this.stereocenters.isStereocenter(v) || (element = FischerRecognition.newTetrahedralCenter(focus, FischerRecognition.neighbors(v, this.graph, this.bonds))) == null) continue;
            IAtom east = element.getLigands()[1];
            IAtom west = element.getLigands()[3];
            if (east != focus && !this.isTerminal(east, atomToIndex) || west != focus && !this.isTerminal(west, atomToIndex)) continue;
            elements.add(element);
        }
        return elements;
    }

    static ITetrahedralChirality newTetrahedralCenter(IAtom focus, IBond[] bonds) {
        IBond[] cardinalBonds = FischerRecognition.cardinalBonds(focus, bonds);
        if (cardinalBonds == null) {
            return null;
        }
        if (!FischerRecognition.isPlanarSigmaBond(cardinalBonds[0]) || !FischerRecognition.isPlanarSigmaBond(cardinalBonds[2])) {
            return null;
        }
        if (cardinalBonds[1] == null && cardinalBonds[3] == null) {
            return null;
        }
        IAtom[] neighbors = new IAtom[]{cardinalBonds[0].getConnectedAtom(focus), focus, cardinalBonds[2].getConnectedAtom(focus), focus};
        if (FischerRecognition.isPlanarSigmaBond(cardinalBonds[1])) {
            neighbors[1] = cardinalBonds[1].getConnectedAtom(focus);
        } else if (cardinalBonds[1] != null || bonds.length == 4) {
            return null;
        }
        if (FischerRecognition.isPlanarSigmaBond(cardinalBonds[3])) {
            neighbors[3] = cardinalBonds[3].getConnectedAtom(focus);
        } else if (cardinalBonds[3] != null || bonds.length == 4) {
            return null;
        }
        return new TetrahedralChirality(focus, neighbors, ITetrahedralChirality.Stereo.ANTI_CLOCKWISE);
    }

    static IBond[] cardinalBonds(IAtom focus, IBond[] bonds) {
        Point2d centerXy = focus.getPoint2d();
        IBond[] cardinal = new IBond[4];
        for (IBond bond : bonds) {
            IAtom other = bond.getConnectedAtom(focus);
            Point2d otherXy = other.getPoint2d();
            double deltaX = otherXy.x - centerXy.x;
            double deltaY = otherXy.y - centerXy.y;
            double mag = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            double absDeltaX = Math.abs(deltaX /= mag);
            double absDeltaY = Math.abs(deltaY /= mag);
            if (absDeltaX < CARDINALITY_THRESHOLD && absDeltaY > CARDINALITY_THRESHOLD) {
                cardinal[deltaY > 0.0 ? 0 : 2] = bond;
                continue;
            }
            if (absDeltaX > CARDINALITY_THRESHOLD && absDeltaY < CARDINALITY_THRESHOLD) {
                cardinal[deltaX > 0.0 ? 1 : 3] = bond;
                continue;
            }
            return null;
        }
        return cardinal;
    }

    private boolean isTerminal(IAtom atom, Map<IAtom, Integer> atomToIndex) {
        return this.graph[atomToIndex.get(atom)].length == 1;
    }

    private static boolean isPlanarSigmaBond(IBond bond) {
        return bond != null && IBond.Order.SINGLE.equals((Object)bond.getOrder()) && IBond.Stereo.NONE.equals((Object)bond.getStereo());
    }

    private static IBond[] neighbors(int v, int[][] g, GraphUtil.EdgeToBondMap bondMap) {
        int[] ws = g[v];
        IBond[] bonds = new IBond[ws.length];
        for (int i = 0; i < ws.length; ++i) {
            bonds[i] = bondMap.get(v, ws[i]);
        }
        return bonds;
    }
}

