/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.FingerprinterTool;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;

public class LingoFingerprinter
implements IFingerprinter {
    private final int n;
    private final SmilesGenerator gen = SmilesGenerator.unique().aromatic();
    private final Pattern DIGITS = Pattern.compile("[0-9]+");
    private final Aromaticity aromaticity = new Aromaticity(ElectronDonation.daylight(), Cycles.or(Cycles.all(), Cycles.relevant()));

    public LingoFingerprinter() {
        this(4);
    }

    public LingoFingerprinter(int n) {
        this.n = n;
    }

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        return FingerprinterTool.makeBitFingerprint(this.getRawFingerprint(iAtomContainer));
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer atomContainer) throws CDKException {
        this.aromaticity.apply(atomContainer);
        String smiles = this.replaceDigits(this.gen.create(atomContainer));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int l = smiles.length() - this.n + 1;
        for (int i = 0; i < l; ++i) {
            String subsmi = smiles.substring(i, i + this.n);
            Integer count = (Integer)map.get(subsmi);
            if (count == null) {
                map.put(subsmi, 1);
                continue;
            }
            map.put(subsmi, count + 1);
        }
        return map;
    }

    @Override
    public int getSize() {
        return -1;
    }

    private String replaceDigits(String smiles) {
        return this.DIGITS.matcher(smiles).replaceAll("0");
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        return FingerprinterTool.makeCountFingerprint(this.getRawFingerprint(container));
    }
}

