/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;
import signature.chemistry.AtomPermutor;
import signature.chemistry.Molecule;
import signature.chemistry.MoleculeSignature;

public class PermutationTest {
    public String toSignatureString(Molecule molecule) {
        System.out.println(molecule);
        MoleculeSignature molSig = new MoleculeSignature(molecule);
        int i = 0;
        for (String signatureString : molSig.getVertexSignatureStrings()) {
            System.out.println(String.valueOf(i) + " " + signatureString);
            ++i;
        }
        return molSig.getMolecularSignature();
    }

    public void printIdentity(Molecule molecule, String signature) {
        int[] identity = new int[molecule.getAtomCount()];
        int i = 0;
        while (i < molecule.getAtomCount()) {
            identity[i] = i;
            ++i;
        }
        System.out.println(molecule + "\t" + Arrays.toString(identity) + "\t" + signature);
    }

    public void testSpecificPermutation(Molecule molecule, int[] permutation) {
        String signature = new MoleculeSignature(molecule).getMolecularSignature();
        this.printIdentity(molecule, signature);
        AtomPermutor permutor = new AtomPermutor(molecule);
        permutor.setPermutation(permutation);
        Molecule permutedMolecule = permutor.next();
        String permutedSignature = new MoleculeSignature(permutedMolecule).getMolecularSignature();
        System.out.println(permutedMolecule + "\t" + Arrays.toString(permutor.getCurrentPermutation()) + "\t" + permutedSignature + "\t" + signature.equals(permutedSignature));
        Assert.assertEquals((String)signature, (String)permutedSignature);
    }

    public void permuteCompletely(Molecule molecule) {
        String signature = new MoleculeSignature(molecule).getMolecularSignature();
        this.printIdentity(molecule, signature);
        AtomPermutor permutor = new AtomPermutor(molecule);
        while (permutor.hasNext()) {
            Molecule permutedMolecule = permutor.next();
            String permutedSignature = new MoleculeSignature(permutedMolecule).getMolecularSignature();
            System.out.println(permutedMolecule + "\t" + Arrays.toString(permutor.getCurrentPermutation()) + "\t" + permutedSignature + "\t" + signature.equals(permutedSignature));
            Assert.assertEquals((String)signature, (String)permutedSignature);
        }
    }

    @Test
    public void permuteCNOMolecule() {
        Molecule molecule = new Molecule();
        molecule.addAtom("C");
        molecule.addAtom("N");
        molecule.addAtom("O");
        molecule.addBond(0, 1, 1);
        molecule.addBond(1, 2, 1);
        this.permuteCompletely(molecule);
    }

    @Test
    public void permuteOCCCSC() {
        Molecule molecule = new Molecule();
        molecule.addAtom("O");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("S");
        molecule.addAtom("C");
        molecule.addBond(0, 1, 2);
        molecule.addBond(1, 2, 1);
        molecule.addBond(2, 3, 1);
        molecule.addBond(3, 4, 1);
        molecule.addBond(4, 5, 1);
        this.permuteCompletely(molecule);
    }

    @Test
    public void permuteOCCOCO() {
        Molecule molecule = new Molecule();
        molecule.addAtom("O");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("O");
        molecule.addAtom("C");
        molecule.addAtom("O");
        molecule.addBond(0, 1, 1);
        molecule.addBond(1, 2, 1);
        molecule.addBond(2, 3, 1);
        molecule.addBond(3, 4, 1);
        molecule.addBond(4, 5, 2);
        this.permuteCompletely(molecule);
    }

    @Test
    public void doubleBondChainTest() {
        Molecule molecule = new Molecule();
        int chainLength = 6;
        molecule.addAtom("O");
        molecule.addAtom("C");
        molecule.addAtom("C");
        molecule.addAtom("O");
        molecule.addAtom("C");
        molecule.addAtom("O");
        int i = 0;
        while (i < chainLength - 2) {
            molecule.addSingleBond(i, i + 1);
            ++i;
        }
        molecule.addBond(chainLength - 2, chainLength - 1, 2);
        String sigA = this.toSignatureString(molecule);
        Molecule moleculeB = new Molecule();
        moleculeB.addAtom("O");
        moleculeB.addAtom("C");
        moleculeB.addAtom("C");
        moleculeB.addAtom("C");
        moleculeB.addAtom("O");
        moleculeB.addAtom("O");
        moleculeB.addBond(0, 1, 1);
        moleculeB.addBond(1, 3, 1);
        moleculeB.addBond(2, 4, 1);
        moleculeB.addBond(2, 5, 2);
        moleculeB.addBond(3, 4, 1);
        String sigB = this.toSignatureString(moleculeB);
        Assert.assertEquals((String)sigA, (String)sigB);
    }
}

