/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.tools.manipulator.BondManipulatorTest")
public class BondManipulator {
    @TestMethod(value="testGetAtomArray_IBond")
    public static IAtom[] getAtomArray(IBond container) {
        IAtom[] ret = new IAtom[container.getAtomCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getAtom(i);
        }
        return ret;
    }

    @TestMethod(value="testIsLowerOrder_IBond_Order_IBond_Order")
    public static boolean isLowerOrder(IBond.Order first, IBond.Order second) {
        if (first == null || second == null) {
            return false;
        }
        if (second == IBond.Order.QUADRUPLE && first != IBond.Order.QUADRUPLE) {
            return true;
        }
        return second == IBond.Order.TRIPLE ? first == IBond.Order.SINGLE || first == IBond.Order.DOUBLE : second == IBond.Order.DOUBLE && first == IBond.Order.SINGLE;
    }

    @TestMethod(value="testIsHigherOrder_IBond_Order_IBond_Order")
    public static boolean isHigherOrder(IBond.Order first, IBond.Order second) {
        if (first == null || second == null) {
            return false;
        }
        if (second == IBond.Order.QUADRUPLE) {
            return false;
        }
        return second == IBond.Order.TRIPLE ? first == IBond.Order.QUADRUPLE : (second == IBond.Order.DOUBLE ? first == IBond.Order.TRIPLE || first == IBond.Order.QUADRUPLE : second == IBond.Order.SINGLE && first != IBond.Order.SINGLE);
    }

    @TestMethod(value="testIncreaseBondOrder_IBond_Order")
    public static IBond.Order increaseBondOrder(IBond.Order oldOrder) {
        if (oldOrder == IBond.Order.TRIPLE) {
            return IBond.Order.QUADRUPLE;
        }
        if (oldOrder == IBond.Order.DOUBLE) {
            return IBond.Order.TRIPLE;
        }
        if (oldOrder == IBond.Order.SINGLE) {
            return IBond.Order.DOUBLE;
        }
        return oldOrder;
    }

    @TestMethod(value="testIncreaseBondOrder_IBond")
    public static void increaseBondOrder(IBond bond) {
        bond.setOrder(BondManipulator.increaseBondOrder(bond.getOrder()));
    }

    @TestMethod(value="testDecreaseBondOrder_IBond_Order")
    public static IBond.Order decreaseBondOrder(IBond.Order oldOrder) {
        if (oldOrder == IBond.Order.TRIPLE) {
            return IBond.Order.DOUBLE;
        }
        if (oldOrder == IBond.Order.DOUBLE) {
            return IBond.Order.SINGLE;
        }
        if (oldOrder == IBond.Order.QUADRUPLE) {
            return IBond.Order.TRIPLE;
        }
        return oldOrder;
    }

    @TestMethod(value="testDecreaseBondOrder_IBond")
    public static void decreaseBondOrder(IBond bond) {
        bond.setOrder(BondManipulator.decreaseBondOrder(bond.getOrder()));
    }

    @TestMethod(value="testCreateBondOrder_double")
    public static IBond.Order createBondOrder(double bondOrder) {
        if (bondOrder == 1.0) {
            return IBond.Order.SINGLE;
        }
        if (bondOrder == 2.0) {
            return IBond.Order.DOUBLE;
        }
        if (bondOrder == 3.0) {
            return IBond.Order.TRIPLE;
        }
        if (bondOrder == 4.0) {
            return IBond.Order.QUADRUPLE;
        }
        return null;
    }

    @TestMethod(value="testDestroyBondOrder_IBond_Order")
    public static double destroyBondOrder(IBond.Order bondOrder) {
        if (bondOrder == IBond.Order.SINGLE) {
            return 1.0;
        }
        if (bondOrder == IBond.Order.DOUBLE) {
            return 2.0;
        }
        if (bondOrder == IBond.Order.TRIPLE) {
            return 3.0;
        }
        return 4.0;
    }

    @TestMethod(value="testGetMaximumBondOrder_List")
    public static IBond.Order getMaximumBondOrder(List<IBond> bonds) {
        return BondManipulator.getMaximumBondOrder(bonds.iterator());
    }

    @TestMethod(value="testGetMaximumBondOrder_Iterator")
    public static IBond.Order getMaximumBondOrder(Iterator<IBond> bonds) {
        IBond.Order maxOrder = IBond.Order.SINGLE;
        while (bonds.hasNext()) {
            IBond bond = bonds.next();
            if (!BondManipulator.isHigherOrder(bond.getOrder(), maxOrder)) continue;
            maxOrder = bond.getOrder();
        }
        return maxOrder;
    }

    @TestMethod(value="testGetMinimumBondOrder_List")
    public static IBond.Order getMinimumBondOrder(List<IBond> bonds) {
        return BondManipulator.getMinimumBondOrder(bonds.iterator());
    }

    @TestMethod(value="testGetMinimumBondOrder_Iterator")
    public static IBond.Order getMinimumBondOrder(Iterator<IBond> bonds) {
        IBond.Order minOrder = IBond.Order.QUADRUPLE;
        while (bonds.hasNext()) {
            IBond bond = bonds.next();
            if (!BondManipulator.isLowerOrder(bond.getOrder(), minOrder)) continue;
            minOrder = bond.getOrder();
        }
        return minOrder;
    }

    @TestMethod(value="testGetSingleBondEquivalentSum_List")
    public static int getSingleBondEquivalentSum(List<IBond> bonds) {
        return BondManipulator.getSingleBondEquivalentSum(bonds.iterator());
    }

    @TestMethod(value="testGetSingleBondEquivalentSum_Iterator")
    public static int getSingleBondEquivalentSum(Iterator<IBond> bonds) {
        int sum = 0;
        while (bonds.hasNext()) {
            IBond nextBond = bonds.next();
            if (nextBond.getOrder() == IBond.Order.SINGLE) {
                ++sum;
                continue;
            }
            if (nextBond.getOrder() == IBond.Order.DOUBLE) {
                sum += 2;
                continue;
            }
            if (nextBond.getOrder() == IBond.Order.TRIPLE) {
                sum += 3;
                continue;
            }
            if (nextBond.getOrder() != IBond.Order.QUADRUPLE) continue;
            sum += 4;
        }
        return sum;
    }
}

