/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.tools.FormatStringBufferTest")
public class FormatStringBuffer {
    private static final int ZEROPAD = 1;
    private static final int PLUS = 4;
    private static final int SPACE = 8;
    private static final int LEFT = 16;
    private static final int SPECIAL = 32;
    private static final int LARGE = 64;
    private static final int SCI = 128;
    private static final int UPPER = 256;
    private static final int GROUPING = 512;
    private static final int CHAR = 0;
    private static final int STRING = 1;
    private static final int DECIMAL = 2;
    private static final int FLOAT = 3;
    private String format = null;
    private StringBuffer buffer = null;
    private int index = 0;

    public FormatStringBuffer(String format) {
        this.reset(format);
    }

    @TestMethod(value="testReset_String")
    public FormatStringBuffer reset(String format) {
        this.reset();
        this.format = format;
        return this;
    }

    @TestMethod(value="testReset")
    public FormatStringBuffer reset() {
        this.buffer = new StringBuffer();
        this.index = 0;
        return this;
    }

    private Format getFormat() {
        block20: while (this.index < this.format.length()) {
            char ch = this.format.charAt(this.index);
            if (ch != '%') {
                this.buffer.append(ch);
                ++this.index;
                continue;
            }
            Format fmt = new Format();
            boolean repeat = true;
            block21: while (repeat) {
                if (this.index + 1 >= this.format.length()) {
                    throw new IllegalArgumentException("Malformed format");
                }
                ch = this.format.charAt(++this.index);
                switch (ch) {
                    case '-': {
                        fmt.flags |= 0x10;
                        continue block21;
                    }
                    case '+': {
                        fmt.flags |= 4;
                        continue block21;
                    }
                    case ' ': {
                        fmt.flags |= 8;
                        continue block21;
                    }
                    case '#': {
                        fmt.flags |= 0x20;
                        continue block21;
                    }
                    case '0': {
                        fmt.flags |= 1;
                        continue block21;
                    }
                    case '\'': {
                        fmt.flags |= 0x200;
                        continue block21;
                    }
                }
                repeat = false;
            }
            if (Character.isDigit(ch)) {
                fmt.fieldWidth = this.skipDigits();
            }
            if (this.index >= this.format.length()) {
                throw new IllegalArgumentException("Malformed format");
            }
            ch = this.format.charAt(this.index);
            if (ch == '.') {
                if (++this.index >= this.format.length()) {
                    throw new IllegalArgumentException("Malformed format");
                }
                fmt.precision = this.skipDigits();
                if (fmt.precision < 0) {
                    fmt.precision = 0;
                }
            }
            if (this.index >= this.format.length()) {
                throw new IllegalArgumentException("Malformed format");
            }
            ch = this.format.charAt(this.index++);
            switch (ch) {
                case 'c': {
                    fmt.type = 0;
                    return fmt;
                }
                case 's': {
                    fmt.type = 1;
                    return fmt;
                }
                case '%': {
                    this.buffer.append('%');
                    continue block20;
                }
                case 'o': {
                    fmt.type = 2;
                    fmt.base = 8;
                    return fmt;
                }
                case 'X': {
                    fmt.flags |= 0x40;
                }
                case 'x': {
                    fmt.type = 2;
                    fmt.base = 16;
                    return fmt;
                }
                case 'd': 
                case 'i': {
                    fmt.type = 2;
                    return fmt;
                }
                case 'f': 
                case 'g': {
                    fmt.type = 3;
                    return fmt;
                }
                case 'e': {
                    fmt.type = 3;
                    fmt.flags |= 0x80;
                    return fmt;
                }
                case 'E': {
                    fmt.type = 3;
                    fmt.flags |= 0x80;
                    fmt.flags |= 0x100;
                    return fmt;
                }
            }
            this.buffer.append('%');
            this.buffer.append(ch);
        }
        return null;
    }

    private int skipDigits() {
        char ch;
        int i = 0;
        while (this.index < this.format.length() && Character.isDigit(ch = this.format.charAt(this.index))) {
            ++this.index;
            i = i * 10 + Character.digit(ch, 10);
        }
        return i;
    }

    @TestMethod(value="testFormat_char")
    public FormatStringBuffer format(char ch) {
        Format fmt = this.getFormat();
        if (fmt.type != 0) {
            throw new IllegalArgumentException("Expected a char format");
        }
        if ((fmt.flags & 0x10) != 16) {
            while (--fmt.fieldWidth > 0) {
                this.buffer.append(' ');
            }
        }
        this.buffer.append(ch);
        while (--fmt.fieldWidth > 0) {
            this.buffer.append(' ');
        }
        return this;
    }

    @TestMethod(value="testFormat_floatr")
    public FormatStringBuffer format(float flt) {
        return this.format((double)flt);
    }

    @TestMethod(value="testFormat_double")
    public FormatStringBuffer format(double dbl) {
        Format fmt = this.getFormat();
        if (fmt.type != 3) {
            throw new IllegalArgumentException("Expected a float format");
        }
        NumberFormat nf = (fmt.flags & 0x80) > 0 ? new DecimalFormat("0.#E00") : NumberFormat.getInstance();
        nf.setGroupingUsed((fmt.flags & 0x200) != 0);
        if (fmt.precision != -1) {
            nf.setMaximumFractionDigits(fmt.precision);
            nf.setMinimumFractionDigits(fmt.precision);
        } else {
            nf.setMaximumFractionDigits(Integer.MAX_VALUE);
            nf.setMinimumFractionDigits(1);
        }
        String str = nf.format(dbl);
        if ((fmt.flags & 0x80) == 128 && (fmt.flags & 0x100) == 0) {
            str = str.replace('E', 'e');
        }
        if ((fmt.flags & 4) == 4 && dbl >= 0.0) {
            str = "+" + str;
        }
        int len = str.length();
        if ((fmt.flags & 0x10) != 16) {
            while (len < fmt.fieldWidth--) {
                this.buffer.append(' ');
            }
        }
        for (int i = 0; i < len; ++i) {
            this.buffer.append(str.charAt(i));
        }
        while (len < fmt.fieldWidth--) {
            this.buffer.append(' ');
        }
        return this;
    }

    @TestMethod(value="testFormat_int")
    public FormatStringBuffer format(int i) {
        return this.format((long)i);
    }

    @TestMethod(value="testFormat_long")
    public FormatStringBuffer format(long l) {
        String str;
        Format fmt = this.getFormat();
        if (fmt.type != 2) {
            throw new IllegalArgumentException("Expected a float format");
        }
        char pad = ' ';
        if ((fmt.flags & 1) == 1) {
            pad = '0';
        }
        String prefix = "";
        switch (fmt.base) {
            case 8: {
                str = Long.toOctalString(l);
                if ((fmt.flags & 0x20) != 32) break;
                --fmt.fieldWidth;
                prefix = "0";
                break;
            }
            case 16: {
                str = Long.toHexString(l);
                if ((fmt.flags & 0x20) != 32) break;
                fmt.fieldWidth -= 2;
                prefix = "0x";
                break;
            }
            default: {
                str = String.valueOf(Math.abs(l));
            }
        }
        if ((fmt.flags & 0x40) == 64) {
            str = str.toUpperCase();
            prefix = prefix.toUpperCase();
        }
        int len = str.length();
        if (l < 0L || (fmt.flags & 4) == 4) {
            --fmt.fieldWidth;
        }
        if ((fmt.flags & 1) == 1) {
            if (l < 0L && fmt.base == 10) {
                this.buffer.append('-');
            } else if ((fmt.flags & 4) == 4 && fmt.base == 10) {
                this.buffer.append('+');
            }
            this.buffer.append(prefix);
        }
        if ((fmt.flags & 0x10) != 16) {
            while (len < fmt.fieldWidth--) {
                this.buffer.append(pad);
            }
        }
        if ((fmt.flags & 1) != 1) {
            if (l < 0L && fmt.base == 10) {
                this.buffer.append('-');
            } else if ((fmt.flags & 4) == 4 && fmt.base == 10) {
                this.buffer.append('+');
            }
            this.buffer.append(prefix);
        }
        for (int i = 0; i < len; ++i) {
            this.buffer.append(str.charAt(i));
        }
        while (len < fmt.fieldWidth--) {
            this.buffer.append(' ');
        }
        return this;
    }

    @TestMethod(value="testFormat_String")
    public FormatStringBuffer format(String str) {
        if (str == null) {
            str = "<NULL>";
        }
        Format fmt = this.getFormat();
        if (fmt.type != 1) {
            throw new IllegalArgumentException("Expected a String format");
        }
        int len = str.length();
        if (fmt.precision != -1 && len > fmt.precision) {
            len = fmt.precision;
        }
        if ((fmt.flags & 0x10) != 16) {
            while (len < fmt.fieldWidth--) {
                this.buffer.append(' ');
            }
        }
        for (int i = 0; i < len; ++i) {
            this.buffer.append(str.charAt(i));
        }
        while (len < fmt.fieldWidth--) {
            this.buffer.append(' ');
        }
        return this;
    }

    @TestMethod(value="testToString")
    public String toString() {
        if (this.index < this.format.length()) {
            this.buffer.append(this.format.substring(this.index));
        }
        String str = this.buffer.toString();
        this.reset();
        return str;
    }

    private class Format {
        public int flags = 0;
        public int fieldWidth = -1;
        public int precision = -1;
        public int type = -1;
        public int base = 10;

        private Format() {
        }
    }
}

