/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.HashMap;
import java.util.Map;
import signature.ColoredTree;

public abstract class AbstractGraphBuilder {
    private Map<Integer, Integer> colorToVertexIndexMap = new HashMap<Integer, Integer>();
    private int vertexCount = 0;

    public void makeFromColoredTree(ColoredTree tree) {
        this.makeGraph();
        ColoredTree.Node root = tree.getRoot();
        this.makeVertex(root.label);
        this.vertexCount = 1;
        for (ColoredTree.Node child : root.children) {
            this.makeFromColoredTreeNode(root, child, 0);
        }
    }

    private void makeFromColoredTreeNode(ColoredTree.Node parent, ColoredTree.Node node, int parentIndex) {
        int vertexIndex;
        if (node.isColored()) {
            if (this.colorToVertexIndexMap.containsKey(node.color)) {
                vertexIndex = this.colorToVertexIndexMap.get(node.color);
            } else {
                this.makeVertex(node.label);
                ++this.vertexCount;
                vertexIndex = this.vertexCount - 1;
                this.colorToVertexIndexMap.put(node.color, vertexIndex);
            }
        } else {
            this.makeVertex(node.label);
            ++this.vertexCount;
            vertexIndex = this.vertexCount - 1;
        }
        this.makeEdge(parentIndex, vertexIndex, parent.label, node.label, node.edgeLabel);
        for (ColoredTree.Node child : node.children) {
            this.makeFromColoredTreeNode(node, child, vertexIndex);
        }
    }

    public abstract void makeGraph();

    public abstract void makeVertex(String var1);

    public abstract void makeEdge(int var1, int var2, String var3, String var4, String var5);
}

