/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.layout.AtomPlacer;
import org.openscience.cdk.modeling.builder3d.AtomPlacer3D;
import org.openscience.cdk.modeling.builder3d.AtomTetrahedralLigandPlacer3D;
import org.openscience.cdk.modeling.builder3d.ForceFieldConfigurator;
import org.openscience.cdk.modeling.builder3d.TemplateHandler3D;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class ModelBuilder3D {
    private static Map<String, ModelBuilder3D> memyselfandi = new HashMap<String, ModelBuilder3D>();
    private TemplateHandler3D templateHandler = null;
    private Map parameterSet = null;
    private final ForceFieldConfigurator ffc = new ForceFieldConfigurator();
    String forceFieldName = "mm2";
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ModelBuilder3D.class);

    private ModelBuilder3D(TemplateHandler3D templateHandler, String ffname) throws CDKException {
        this.setTemplateHandler(templateHandler);
        this.setForceField(ffname);
    }

    public static ModelBuilder3D getInstance(TemplateHandler3D templateHandler, String ffname) throws CDKException {
        if (ffname == null || ffname.length() == 0) {
            throw new CDKException("The given ffname is null or empty!");
        }
        if (templateHandler == null) {
            throw new CDKException("The given template handler is null!");
        }
        String builderCode = templateHandler.getClass().getName() + "#" + ffname;
        if (!memyselfandi.containsKey(builderCode)) {
            ModelBuilder3D builder = new ModelBuilder3D(templateHandler, ffname);
            memyselfandi.put(builderCode, builder);
            return builder;
        }
        return memyselfandi.get(builderCode);
    }

    public static ModelBuilder3D getInstance() throws CDKException {
        return ModelBuilder3D.getInstance(TemplateHandler3D.getInstance(), "mm2");
    }

    public String[] getFfTypes() {
        return this.ffc.getFfTypes();
    }

    private void setForceField(String ffname) throws CDKException {
        if (ffname == null) {
            ffname = "mm2";
        }
        try {
            this.forceFieldName = ffname;
            this.ffc.setForceFieldConfigurator(ffname);
            this.parameterSet = this.ffc.getParameterSet();
        }
        catch (CDKException ex1) {
            logger.error("Problem with ForceField configuration due to>" + ex1.getMessage());
            logger.debug(ex1);
            throw new CDKException("Problem with ForceField configuration due to>" + ex1.getMessage(), ex1);
        }
    }

    public IMolecule generate3DCoordinates(IMolecule molecule, boolean clone) throws CDKException, NoSuchAtomTypeException, CloneNotSupportedException, IOException {
        int i;
        String[] originalAtomTypeNames = new String[molecule.getAtomCount()];
        for (i = 0; i < originalAtomTypeNames.length; ++i) {
            originalAtomTypeNames[i] = molecule.getAtom(i).getAtomTypeName();
        }
        logger.debug("******** GENERATE COORDINATES ********");
        for (i = 0; i < molecule.getAtomCount(); ++i) {
            molecule.getAtom(i).setFlag(0, false);
            molecule.getAtom(i).setFlag(4, false);
        }
        logger.debug("#atoms>" + molecule.getAtomCount());
        if (!ConnectivityChecker.isConnected(molecule)) {
            throw new CDKException("Molecule is NOT connected, could not layout.");
        }
        AtomPlacer atomPlacer = new AtomPlacer();
        AtomPlacer3D ap3d = new AtomPlacer3D();
        AtomTetrahedralLigandPlacer3D atlp3d = new AtomTetrahedralLigandPlacer3D();
        ap3d.initilize(this.parameterSet);
        atlp3d.setParameterSet(this.parameterSet);
        if (clone) {
            molecule = (IMolecule)molecule.clone();
        }
        atomPlacer.setMolecule(molecule);
        if (ap3d.numberOfUnplacedHeavyAtoms(molecule) == 1) {
            logger.debug("Only one Heavy Atom");
            molecule.getAtom(0).setPoint3d(new Point3d(0.0, 0.0, 0.0));
            try {
                atlp3d.add3DCoordinatesForSinglyBondedLigands(molecule);
            }
            catch (CDKException ex3) {
                logger.error("PlaceSubstitutensERROR: Cannot place substitutents due to:" + ex3.getMessage());
                logger.debug(ex3);
                throw new CDKException("PlaceSubstitutensERROR: Cannot place substitutents due to:" + ex3.getMessage(), ex3);
            }
            return molecule;
        }
        IRingSet ringSetMolecule = this.ffc.assignAtomTyps(molecule);
        List<IRingSet> ringSystems = null;
        IRingSet largestRingSet = null;
        double NumberOfRingAtoms = 0.0;
        if (ringSetMolecule.getAtomContainerCount() > 0) {
            if (this.templateHandler == null) {
                throw new CDKException("You are trying to generate coordinates for a molecule with rings, but you have no template handler set. Please do setTemplateHandler() before generation!");
            }
            ringSystems = RingPartitioner.partitionRings(ringSetMolecule);
            largestRingSet = RingSetManipulator.getLargestRingSet(ringSystems);
            IAtomContainer largestRingSetContainer = RingSetManipulator.getAllInOneContainer(largestRingSet);
            NumberOfRingAtoms = largestRingSetContainer.getAtomCount();
            this.templateHandler.mapTemplates(largestRingSetContainer, NumberOfRingAtoms);
            if (!this.checkAllRingAtomsHasCoordinates(largestRingSetContainer)) {
                throw new CDKException("RingAtomLayoutError: Not every ring atom is placed! Molecule cannot be layout.");
            }
            this.setAtomsToPlace(largestRingSetContainer);
            this.searchAndPlaceBranches(molecule, largestRingSetContainer, ap3d, atlp3d, atomPlacer);
            largestRingSet = null;
        } else {
            IAtomContainer ac = null;
            ac = atomPlacer.getInitialLongestChain(molecule);
            this.setAtomsToUnVisited(molecule);
            this.setAtomsToUnPlaced(molecule);
            ap3d.placeAliphaticHeavyChain(molecule, ac);
            ap3d.zmatrixChainToCartesian(molecule, false);
            this.searchAndPlaceBranches(molecule, ac, ap3d, atlp3d, atomPlacer);
        }
        this.layoutMolecule(ringSystems, molecule, ap3d, atlp3d, atomPlacer);
        try {
            atlp3d.add3DCoordinatesForSinglyBondedLigands(molecule);
        }
        catch (CDKException ex3) {
            logger.error("PlaceSubstitutensERROR: Cannot place substitutents due to:" + ex3.getMessage());
            logger.debug(ex3);
            throw new CDKException("PlaceSubstitutensERROR: Cannot place substitutents due to:" + ex3.getMessage(), ex3);
        }
        for (int i2 = 0; i2 < originalAtomTypeNames.length; ++i2) {
            molecule.getAtom(i2).setAtomTypeName(originalAtomTypeNames[i2]);
        }
        return molecule;
    }

    private IRingSet getRingSetOfAtom(List ringSystems, IAtom atom) {
        IRingSet ringSetOfAtom = null;
        for (int i = 0; i < ringSystems.size(); ++i) {
            if (!((IRingSet)ringSystems.get(i)).contains(atom)) continue;
            return (IRingSet)ringSystems.get(i);
        }
        return ringSetOfAtom;
    }

    private void layoutMolecule(List ringSetMolecule, IMolecule molecule, AtomPlacer3D ap3d, AtomTetrahedralLigandPlacer3D atlp3d, AtomPlacer atomPlacer) throws CDKException, IOException, CloneNotSupportedException {
        IAtomContainer ac = null;
        int safetyCounter = 0;
        IAtom atom = null;
        do {
            ++safetyCounter;
            atom = ap3d.getNextPlacedHeavyAtomWithUnplacedRingNeighbour(molecule);
            if (atom != null) {
                IAtom unplacedAtom = ap3d.getUnplacedRingHeavyAtom(molecule, atom);
                IRingSet ringSetA = this.getRingSetOfAtom(ringSetMolecule, unplacedAtom);
                IAtomContainer ringSetAContainer = RingSetManipulator.getAllInOneContainer(ringSetA);
                this.templateHandler.mapTemplates(ringSetAContainer, ringSetAContainer.getAtomCount());
                if (!this.checkAllRingAtomsHasCoordinates(ringSetAContainer)) {
                    throw new IOException("RingAtomLayoutError: Not every ring atom is placed! Molecule cannot be layout.Sorry");
                }
                Point3d firstAtomOriginalCoord = unplacedAtom.getPoint3d();
                Point3d centerPlacedMolecule = ap3d.geometricCenterAllPlacedAtoms(molecule);
                this.setBranchAtom(molecule, unplacedAtom, atom, ap3d.getPlacedHeavyAtoms(molecule, atom), ap3d, atlp3d);
                this.layoutRingSystem(firstAtomOriginalCoord, unplacedAtom, ringSetA, centerPlacedMolecule, atom, ap3d);
                this.searchAndPlaceBranches(molecule, ringSetAContainer, ap3d, atlp3d, atomPlacer);
                ringSetA = null;
                unplacedAtom = null;
                firstAtomOriginalCoord = null;
                centerPlacedMolecule = null;
                continue;
            }
            this.setAtomsToUnVisited(molecule);
            atom = ap3d.getNextPlacedHeavyAtomWithUnplacedAliphaticNeighbour(molecule);
            if (atom == null) continue;
            ac = atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            ac.addAtom(atom);
            this.searchAndPlaceBranches(molecule, ac, ap3d, atlp3d, atomPlacer);
            ac = null;
        } while (!ap3d.allHeavyAtomsPlaced(molecule) || safetyCounter > molecule.getAtomCount());
    }

    private void layoutRingSystem(Point3d originalCoord, IAtom placedRingAtom, IRingSet ringSet, Point3d centerPlacedMolecule, IAtom atomB, AtomPlacer3D ap3d) {
        int i;
        IAtomContainer ac = RingSetManipulator.getAllInOneContainer(ringSet);
        Point3d newCoord = placedRingAtom.getPoint3d();
        Vector3d axis = new Vector3d(atomB.getPoint3d().x - newCoord.x, atomB.getPoint3d().y - newCoord.y, atomB.getPoint3d().z - newCoord.z);
        this.translateStructure(originalCoord, newCoord, ac);
        Vector3d startAtomVector = new Vector3d(newCoord.x - atomB.getPoint3d().x, newCoord.y - atomB.getPoint3d().y, newCoord.z - atomB.getPoint3d().z);
        IAtom farthestAtom = ap3d.getFarthestAtom(placedRingAtom.getPoint3d(), ac);
        Vector3d farthestAtomVector = new Vector3d(farthestAtom.getPoint3d().x - newCoord.x, farthestAtom.getPoint3d().y - newCoord.y, farthestAtom.getPoint3d().z - newCoord.z);
        Vector3d n1 = new Vector3d();
        n1.cross(axis, farthestAtomVector);
        n1.normalize();
        double lengthFarthestAtomVector = farthestAtomVector.length();
        Vector3d farthestVector = new Vector3d(startAtomVector);
        farthestVector.normalize();
        farthestVector.scale(startAtomVector.length() + lengthFarthestAtomVector);
        double dotProduct = farthestAtomVector.dot(farthestVector);
        double angle = Math.acos(dotProduct / (farthestAtomVector.length() * farthestVector.length()));
        Vector3d ringCenter = new Vector3d();
        for (int i2 = 0; i2 < ac.getAtomCount(); ++i2) {
            if (ac.getAtom(i2).getFlag(0)) continue;
            ringCenter.x = ac.getAtom((int)i2).getPoint3d().x - newCoord.x;
            ringCenter.y = ac.getAtom((int)i2).getPoint3d().y - newCoord.y;
            ringCenter.z = ac.getAtom((int)i2).getPoint3d().z - newCoord.z;
            ringCenter = AtomTetrahedralLigandPlacer3D.rotate(ringCenter, n1, angle);
            ac.getAtom(i2).setPoint3d(new Point3d(ringCenter.x + newCoord.x, ringCenter.y + newCoord.y, ringCenter.z + newCoord.z));
        }
        Point3d pointRingCenter = GeometryTools.get3DCenter(ac);
        double distance = 0.0;
        double rotAngleMax = 0.0;
        angle = 0.0;
        ringCenter = new Vector3d(pointRingCenter.x, pointRingCenter.y, pointRingCenter.z);
        ringCenter.x -= newCoord.x;
        ringCenter.y -= newCoord.y;
        ringCenter.z -= newCoord.z;
        for (i = 1; i < 360; ++i) {
            ringCenter = AtomTetrahedralLigandPlacer3D.rotate(ringCenter, axis, angle);
            Point3d point3d = new Point3d(ringCenter.x, ringCenter.y, ringCenter.z);
            if (!(centerPlacedMolecule.distance(point3d) > distance)) continue;
            rotAngleMax = i;
            distance = centerPlacedMolecule.distance(new Point3d(ringCenter.x, ringCenter.y, ringCenter.z));
        }
        rotAngleMax = rotAngleMax / 180.0 * Math.PI;
        for (i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getFlag(0)) continue;
            ringCenter.x = ac.getAtom((int)i).getPoint3d().x;
            ringCenter.y = ac.getAtom((int)i).getPoint3d().y;
            ringCenter.z = ac.getAtom((int)i).getPoint3d().z;
            ringCenter = AtomTetrahedralLigandPlacer3D.rotate(ringCenter, axis, rotAngleMax);
            ac.getAtom(i).setPoint3d(new Point3d(ringCenter.x, ringCenter.y, ringCenter.z));
            ac.getAtom(i).setFlag(0, true);
        }
    }

    private void setBranchAtom(IMolecule molecule, IAtom unplacedAtom, IAtom atomA, IAtomContainer atomNeighbours, AtomPlacer3D ap3d, AtomTetrahedralLigandPlacer3D atlp3d) throws CDKException {
        IAtomContainer noCoords = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        noCoords.addAtom(unplacedAtom);
        Point3d centerPlacedMolecule = ap3d.geometricCenterAllPlacedAtoms(molecule);
        IAtom atomB = atomNeighbours.getAtom(0);
        String atypeNameA = atomA.getAtomTypeName();
        String atypeNameB = atomB.getAtomTypeName();
        String atypeNameUnplaced = unplacedAtom.getAtomTypeName();
        double length = ap3d.getBondLengthValue(atypeNameA, atypeNameUnplaced);
        double angle = ap3d.getAngleValue(atypeNameB, atypeNameA, atypeNameUnplaced) * Math.PI / 180.0;
        IAtom atomC = ap3d.getPlacedHeavyAtom(molecule, atomB, atomA);
        Point3d[] branchPoints = atlp3d.get3DCoordinatesForLigands(atomA, noCoords, atomNeighbours, atomC, atomA.getFormalNeighbourCount() - atomNeighbours.getAtomCount(), length, angle);
        double distance = 0.0;
        int farthestPoint = 0;
        for (int i = 0; i < branchPoints.length; ++i) {
            if (!(Math.abs(branchPoints[i].distance(centerPlacedMolecule)) > Math.abs(distance))) continue;
            distance = branchPoints[i].distance(centerPlacedMolecule);
            farthestPoint = i;
        }
        int stereo = -1;
        IBond unplacedBond = molecule.getBond(atomA, unplacedAtom);
        if ((atomA.getStereoParity() != CDKConstants.UNSET && atomA.getStereoParity() != 0 || (unplacedBond.getStereo() == IBond.Stereo.UP || unplacedBond.getStereo() == IBond.Stereo.DOWN) && molecule.getMaximumBondOrder(atomA) == IBond.Order.SINGLE) && atomNeighbours.getAtomCount() > 1) {
            stereo = atlp3d.makeStereocenter(atomA.getPoint3d(), molecule.getBond(atomA, unplacedAtom), atomNeighbours.getAtom(0).getPoint3d(), atomNeighbours.getAtom(1).getPoint3d(), branchPoints);
        }
        if (stereo != -1) {
            farthestPoint = stereo;
        }
        unplacedAtom.setPoint3d(branchPoints[farthestPoint]);
        unplacedAtom.setFlag(0, true);
    }

    private void searchAndPlaceBranches(IMolecule molecule, IAtomContainer chain, AtomPlacer3D ap3d, AtomTetrahedralLigandPlacer3D atlp3d, AtomPlacer atomPlacer) throws CDKException {
        List<IAtom> atoms = null;
        IAtomContainer branchAtoms = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer connectedAtoms = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int i = 0; i < chain.getAtomCount(); ++i) {
            atoms = molecule.getConnectedAtomsList(chain.getAtom(i));
            for (int j = 0; j < atoms.size(); ++j) {
                IAtom atom = atoms.get(j);
                if (!(!atom.getSymbol().equals("H") & !atom.getFlag(0) & !atom.getFlag(1))) continue;
                connectedAtoms.add(ap3d.getPlacedHeavyAtoms(molecule, chain.getAtom(i)));
                try {
                    this.setBranchAtom(molecule, atom, chain.getAtom(i), connectedAtoms, ap3d, atlp3d);
                }
                catch (CDKException ex2) {
                    logger.error("SearchAndPlaceBranchERROR: Cannot find enough neighbour atoms due to" + ex2.toString());
                    throw new CDKException("SearchAndPlaceBranchERROR: Cannot find enough neighbour atoms: " + ex2.getMessage(), ex2);
                }
                branchAtoms.addAtom(atom);
                connectedAtoms.removeAllElements();
            }
        }
        this.placeLinearChains3D(molecule, branchAtoms, ap3d, atlp3d, atomPlacer);
    }

    private void placeLinearChains3D(IMolecule molecule, IAtomContainer startAtoms, AtomPlacer3D ap3d, AtomTetrahedralLigandPlacer3D atlp3d, AtomPlacer atomPlacer) throws CDKException {
        IAtom dihPlacedAtom = null;
        IAtom thirdPlacedAtom = null;
        IAtomContainer longestUnplacedChain = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        if (startAtoms.getAtomCount() != 0) {
            for (int i = 0; i < startAtoms.getAtomCount(); ++i) {
                thirdPlacedAtom = ap3d.getPlacedHeavyAtom(molecule, startAtoms.getAtom(i));
                dihPlacedAtom = ap3d.getPlacedHeavyAtom(molecule, thirdPlacedAtom, startAtoms.getAtom(i));
                longestUnplacedChain.addAtom(dihPlacedAtom);
                longestUnplacedChain.addAtom(thirdPlacedAtom);
                longestUnplacedChain.addAtom(startAtoms.getAtom(i));
                longestUnplacedChain.add(atomPlacer.getLongestUnplacedChain(molecule, startAtoms.getAtom(i)));
                this.setAtomsToUnVisited(molecule);
                if (longestUnplacedChain.getAtomCount() >= 4) {
                    ap3d.placeAliphaticHeavyChain(molecule, longestUnplacedChain);
                    ap3d.zmatrixChainToCartesian(molecule, true);
                    this.searchAndPlaceBranches(molecule, longestUnplacedChain, ap3d, atlp3d, atomPlacer);
                }
                longestUnplacedChain.removeAllElements();
            }
        }
    }

    private void translateStructure(Point3d originalCoord, Point3d newCoord, IAtomContainer ac) {
        Point3d transVector = new Point3d(originalCoord);
        transVector.sub(newCoord);
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getFlag(0)) continue;
            ac.getAtom(i).getPoint3d().sub(transVector);
        }
    }

    private boolean checkAllRingAtomsHasCoordinates(IAtomContainer ac) {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getPoint3d() != null && ac.getAtom(i).getFlag(1) || !ac.getAtom(i).getFlag(1)) continue;
            return false;
        }
        return true;
    }

    private void setAtomsToPlace(IAtomContainer ac) {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            ac.getAtom(i).setFlag(0, true);
        }
    }

    private void setAtomsToUnPlaced(IMolecule molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            molecule.getAtom(i).setFlag(0, false);
        }
    }

    private void setAtomsToUnVisited(IMolecule molecule) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            molecule.getAtom(i).setFlag(4, false);
        }
    }

    private void setTemplateHandler(TemplateHandler3D templateHandler) throws CDKException {
        if (templateHandler == null) {
            throw new NullPointerException("The given template handler is null!");
        }
        this.templateHandler = templateHandler;
    }

    public int getTemplateCount() {
        return this.templateHandler.getTemplateCount();
    }
}

