/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jniinchi;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jniinchi.INCHI_KEY;
import net.sf.jniinchi.JniInchiException;

public class JniInchiOutputKey {
    private static final Pattern pattern = Pattern.compile("([A-Z]{14})-([A-Z]{8})([A-Z])([A-Z])");
    private final INCHI_KEY retStatus;
    private final String key;
    private String block1;
    private String block2;
    private char flagChar;
    private char checkChar;

    public JniInchiOutputKey(int ret, String key) throws JniInchiException {
        this(INCHI_KEY.getValue(ret), key);
    }

    public JniInchiOutputKey(INCHI_KEY retStatus, String key) throws JniInchiException {
        if (retStatus == null) {
            throw new NullPointerException("Null return status");
        }
        if (retStatus == INCHI_KEY.OK) {
            if (key == null) {
                throw new NullPointerException("Null InChIkey");
            }
            Matcher m = pattern.matcher(key);
            if (!m.matches()) {
                throw new JniInchiException("Invalid key format: " + key);
            }
            this.block1 = m.group(1);
            this.block2 = m.group(2);
            this.flagChar = m.group(3).charAt(0);
            this.checkChar = m.group(4).charAt(0);
            if (this.flagChar < 'A' || this.flagChar > 'X') {
                throw new JniInchiException("Invalid flag character: " + this.flagChar);
            }
        }
        this.retStatus = retStatus;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public INCHI_KEY getReturnStatus() {
        return this.retStatus;
    }

    public String getFirstBlock() {
        return this.block1;
    }

    public String getSecondBlock() {
        return this.block2;
    }

    public char getFlagChar() {
        return this.flagChar;
    }

    public char getCheckChar() {
        return this.checkChar;
    }

    public int getFlagVersion() {
        int version = 0;
        if (this.flagChar >= 'A' && this.flagChar <= 'H') {
            version = 1;
        } else if (this.flagChar >= 'I' && this.flagChar <= 'P') {
            version = 2;
        } else if (this.flagChar >= 'Q' && this.flagChar <= 'X') {
            version = 3;
        }
        return version;
    }

    public boolean getFlagIsotopic() {
        boolean hasIsotopic = "ABCDIJKLQRST".indexOf(this.flagChar) == -1;
        return hasIsotopic;
    }

    public boolean getFlagFixedH() {
        boolean hasFixedH = "ABEFIJMNQRUV".indexOf(this.flagChar) == -1;
        return hasFixedH;
    }

    public boolean getFlagStereo() {
        boolean hasStereo = "ACEGIKMOQSUW".indexOf(this.flagChar) == -1;
        return hasStereo;
    }
}

