/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.MoveModule;
import org.openscience.cdk.controller.edit.CompositEdit;
import org.openscience.cdk.controller.edit.CreateRing;
import org.openscience.cdk.controller.edit.Merge;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.layout.RingPlacer;

public class AddRingModule
extends ControllerModuleAdapter {
    private int ringSize;
    private boolean addingBenzene = false;
    RingPlacer ringPlacer;
    IRing ring;
    int maxDistance;
    double bondLength = 1.4;

    public AddRingModule(IChemModelRelay chemModelRelay, int ringSize, boolean addingBenzene) {
        super(chemModelRelay);
        this.ringSize = ringSize;
        this.addingBenzene = addingBenzene;
        this.ringPlacer = new RingPlacer();
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        HashMap<IAtom, IAtom> mergeMap = new HashMap<IAtom, IAtom>(this.chemModelRelay.getRenderModel().getMerge());
        Vector2d shift = MoveModule.calcualteShift(mergeMap);
        for (IAtom atom : this.ring.atoms()) {
            atom.getPoint2d().add(shift);
        }
        CreateRing ringEdit = CreateRing.addRing(this.ring);
        Merge mergeEdit = Merge.merge(mergeMap);
        this.ring = null;
        this.chemModelRelay.clearPhantoms();
        this.chemModelRelay.getRenderModel().getMerge().clear();
        this.chemModelRelay.execute(CompositEdit.compose(ringEdit, mergeEdit));
    }

    private void makeRingAromatic(IRing ring) {
        for (int i = 0; i < ring.getBondCount(); ++i) {
            if (i % 2 != 0) continue;
            ring.getBond(i).setOrder(IBond.Order.DOUBLE);
        }
        for (IAtom atom : ring.atoms()) {
            atom.setFlag(5, true);
        }
        for (IBond bond : ring.bonds()) {
            bond.setFlag(5, true);
        }
    }

    private Point2d getConnectedAtomCenter(IAtomContainer ac, IAtom ... atoms) {
        ArrayList connectedAtoms = new ArrayList();
        for (IAtom atom : atoms) {
            connectedAtoms.addAll(ac.getConnectedAtomsList(atom));
        }
        for (IAtom atom : atoms) {
            connectedAtoms.remove(atom);
        }
        if (connectedAtoms.isEmpty()) {
            return null;
        }
        return GeometryTools.get2DCenter(connectedAtoms);
    }

    @Override
    public void mouseMove(Point2d worldCoord) {
        if (this.ring == null) {
            this.bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)this.getModel());
            if (Double.isNaN(this.bondLength) || this.bondLength == 0.0) {
                this.bondLength = 1.4;
            }
            this.ring = (IRing)this.getModel().getBuilder().newInstance(IRing.class, new Object[]{this.ringSize, "C"});
            if (this.addingBenzene) {
                this.makeRingAromatic(this.ring);
            }
            for (IBond bond : this.ring.bonds()) {
                this.chemModelRelay.addPhantomBond(bond);
                for (IAtom atom : bond.atoms()) {
                    this.chemModelRelay.addPhantomAtom(atom);
                }
            }
        }
        IBond bond = this.chemModelRelay.getRenderModel().getHighlightedBond();
        IAtom atom = this.chemModelRelay.getRenderModel().getHighlightedAtom();
        if (bond != null) {
            Vector2d normal;
            IAtomContainer ac = (IAtomContainer)bond.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            IBond ringBond = this.ring.getBond(0);
            for (int i = 0; i < 2; ++i) {
                Point2d atomPos = new Point2d(bond.getAtom(i).getPoint2d());
                ringBond.getAtom(i).setPoint2d(atomPos);
            }
            ac.addBond(ringBond);
            for (IAtom rAtom : ringBond.atoms()) {
                ac.addAtom(rAtom);
            }
            Point2d acCenter = GeometryTools.get2DCenter((IAtomContainer)ac);
            Point2d connCenter = this.getConnectedAtomCenter(this.getModel(), bond.getAtom(0), bond.getAtom(1));
            if (connCenter != null) {
                normal = new Vector2d();
                normal.sub(acCenter, connCenter);
            } else {
                normal = GeometryTools.calculatePerpendicularUnitVector((Point2d)ringBond.getAtom(0).getPoint2d(), (Point2d)ringBond.getAtom(1).getPoint2d());
            }
            this.ringPlacer.placeFusedRing(this.ring, ac, acCenter, normal, this.bondLength);
        } else if (atom != null) {
            Vector2d normal;
            Point2d ringCenter = GeometryTools.get2DCenter((IAtomContainer)this.ring);
            IAtomContainer ac = (IAtomContainer)atom.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            IAtom ringAtom = this.ring.getAtom(0);
            ringAtom.setPoint2d(new Point2d(atom.getPoint2d()));
            ac.addAtom(ringAtom);
            Point2d acCenter = new Point2d(atom.getPoint2d());
            Point2d connCenter = this.getConnectedAtomCenter(this.getModel(), atom);
            if (connCenter != null) {
                normal = new Vector2d();
                normal.sub(acCenter, connCenter);
            } else if (Double.isNaN(ringCenter.x) || Double.isNaN(ringCenter.y)) {
                normal = new Vector2d(1.0, 0.0);
            } else {
                normal = new Vector2d();
                normal.sub(ringCenter, acCenter);
            }
            this.ringPlacer.placeSpiroRing(this.ring, ac, acCenter, normal, this.bondLength);
        } else {
            this.ringPlacer.placeRing(this.ring, worldCoord, this.bondLength);
        }
        Map<IAtom, IAtom> merge = MoveModule.calculateMerge((IAtomContainer)this.ring, this.getModel(), this.getHighlightDistance());
        Map<IAtom, IAtom> oldMerge = this.chemModelRelay.getRenderModel().getMerge();
        oldMerge.clear();
        oldMerge.putAll(merge);
        this.chemModelRelay.updateView();
    }

    @Override
    public String getDrawModeString() {
        if (this.addingBenzene) {
            return "Benzene";
        }
        return "Ring " + this.ringSize;
    }

    @Override
    public void mouseExit(Point2d worldCoord) {
        this.chemModelRelay.clearPhantoms();
        this.chemModelRelay.updateView();
    }

    @Override
    public void mouseEnter(Point2d worldCoord) {
        if (this.ring != null) {
            for (IBond bond : this.ring.bonds()) {
                this.chemModelRelay.addPhantomBond(bond);
            }
        }
    }
}

