/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.font;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openscience.cdk.renderer.font.AbstractFontManager;

public class SWTFontManager
extends AbstractFontManager {
    public String FONT_FAMILY_NAME = "Arial";
    public int FONT_STYLE = 0;
    private HashMap<Integer, Font> fontSizeToFontMap;
    private int minFontSize = 9;
    private Font currentFont;
    private double scale;
    private Device device;

    public SWTFontManager(Device device) {
        this.device = device;
        this.makeFonts();
        this.toMiddle();
        this.resetVirtualCounts();
    }

    public void setFont() {
        String string = this.FONT_FAMILY_NAME = this.getFontName() != null ? this.getFontName() : "Arial";
        if (this.getFontStyle() != null) {
            switch (super.getFontStyle()) {
                case NORMAL: {
                    this.FONT_STYLE = 0;
                    break;
                }
                case BOLD: {
                    this.FONT_STYLE = 1;
                    break;
                }
                default: {
                    this.FONT_STYLE = 3;
                    break;
                }
            }
        } else {
            this.FONT_STYLE = 0;
        }
    }

    private void makeFontsAWT(Device device) {
        this.setFont();
        int size = this.minFontSize;
        double scale = 0.5;
        this.fontSizeToFontMap = new HashMap();
        for (int i = 0; i < 20; ++i) {
            this.fontSizeToFontMap.put(size, new Font(device, this.FONT_FAMILY_NAME, size, this.FONT_STYLE));
            this.registerFontSizeMapping(scale, size);
            ++size;
            scale += 0.1;
        }
    }

    @Override
    public void setFontForZoom(double scale) {
        this.scale = scale;
        int size = this.getFontSizeForZoom(scale);
        if (size != -1) {
            this.currentFont = this.fontSizeToFontMap.get(size);
        }
    }

    public Font getSmallFont() {
        int size = this.getFontSizeForZoom(this.scale * 0.5);
        if (size != -1) {
            return this.fontSizeToFontMap.get(size);
        }
        return this.fontSizeToFontMap.get(this.minFontSize);
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void dispose() {
        ArrayList<Font> fonts = new ArrayList<Font>(this.fontSizeToFontMap.values());
        this.fontSizeToFontMap.clear();
        for (Font font : fonts) {
            font.dispose();
        }
        fonts.clear();
    }

    @Override
    protected void makeFonts() {
        this.makeFontsAWT(this.device);
    }

    public static class FontTest {
        public static void main(String[] args) {
            final Display display = new Display();
            final Shell shell = new Shell(display);
            final SWTFontManager fontManager = new SWTFontManager(display);
            ArrayList list = new ArrayList(fontManager.fontSizeToFontMap.keySet());
            Collections.sort(list);
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                System.out.println(i);
            }
            System.out.println();
            ArrayList<Integer> list2 = new ArrayList<Integer>();
            for (Font i : fontManager.fontSizeToFontMap.values()) {
                FontData fm = i.getFontData()[0];
                list2.add(fm.getHeight());
            }
            Collections.sort(list2);
            Iterator<Object> i$2 = list2.iterator();
            while (i$2.hasNext()) {
                int i = (Integer)i$2.next();
                System.out.println(i);
            }
            System.out.println();
            for (double d = 0.5; d < 2.5; d += 0.1) {
                System.out.println(fontManager.getFontSizeForZoom(d));
            }
            shell.addPaintListener(new PaintListener(){

                @Override
                public void paintControl(PaintEvent event) {
                    FontMetrics fm;
                    Rectangle rect = shell.getClientArea();
                    double low = 0.5;
                    double high = 2.5;
                    double k = (high - low) / (double)rect.height;
                    boolean gra = false;
                    for (int y = 0; y < rect.height; y += fm.getHeight()) {
                        double scale = (double)y * k + low;
                        fontManager.setFontForZoom(scale);
                        Font font = fontManager.getFont();
                        event.gc.setFont(font);
                        fm = event.gc.getFontMetrics();
                        if (gra) {
                            event.gc.setBackground(display.getSystemColor(19));
                        } else {
                            event.gc.setBackground(display.getSystemColor(20));
                        }
                        event.gc.fillRectangle(0, y, rect.width, y + fm.getHeight());
                        event.gc.drawText("C", rect.width / 2, y);
                        event.gc.drawText(Double.toString(Math.floor(scale * 100.0) / 100.0), 3, y);
                        event.gc.drawText(Integer.toString(fm.getHeight()), (int)((double)rect.width * 0.66), y);
                        event.gc.drawText(font != null ? Integer.toString(font.getFontData()[0].getHeight()) : "null", (int)((double)rect.width * 0.75), y);
                        gra = !gra;
                    }
                }
            });
            shell.setBounds(10, 30, 200, 500);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.dispose();
            fontManager.dispose();
        }
    }
}

