/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IAtom;

public class ChangeChargeEdit
implements IUndoRedoable {
    private static final long serialVersionUID = 1237756549190508501L;
    private IAtom atom;
    private int formerCharge;
    private int newCharge;
    private String type;
    private IChemModelRelay chemModelRelay = null;

    public ChangeChargeEdit(IAtom atomInRange, int formerCharge, int newCharge, String type, IChemModelRelay chemModelRelay) {
        this.atom = atomInRange;
        this.formerCharge = formerCharge;
        this.newCharge = newCharge;
        this.type = type;
        this.chemModelRelay = chemModelRelay;
    }

    @Override
    public void redo() {
        this.atom.setFormalCharge(Integer.valueOf(this.newCharge));
        this.chemModelRelay.updateAtom(this.atom);
    }

    @Override
    public void undo() {
        this.atom.setFormalCharge(Integer.valueOf(this.formerCharge));
        this.chemModelRelay.updateAtom(this.atom);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

