/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

public class AddBond
extends AbstractEdit
implements IEdit {
    IAtom atom1;
    IAtom atom2;
    IBond newBond;

    public static AddBond addBond(IAtom atom1, IAtom atom2) {
        return new AddBond(atom1, atom2);
    }

    private AddBond(IAtom atom1, IAtom atom2) {
        this.atom1 = atom1;
        this.atom2 = atom2;
    }

    @Override
    public void redo() {
        if (this.newBond == null) {
            this.newBond = (IBond)this.model.getBuilder().newInstance(IBond.class, new Object[]{this.atom1, this.atom2});
        }
        this.model.addBond(this.newBond);
        this.updateHydrogenCount(this.atom1, this.atom2);
    }

    @Override
    public void undo() {
        this.model.removeBond(this.newBond);
        this.updateHydrogenCount(this.newBond.getAtom(0), this.newBond.getAtom(1));
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return AddBond.changed(Changed.Structure);
    }
}

