/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.renderer.IRenderer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;

public class ZoomModule
extends ControllerModuleAdapter {
    private Point2d worldCoord = null;

    public ZoomModule(IChemModelRelay chemModelRelay) {
        super(chemModelRelay);
    }

    @Override
    public void mouseWheelMovedForward(int clicks) {
        this.doZoom(0.9);
        this.chemModelRelay.fireZoomEvent();
        this.chemModelRelay.updateView();
    }

    @Override
    public void mouseWheelMovedBackward(int clicks) {
        this.doZoom(1.1);
        this.chemModelRelay.fireZoomEvent();
        this.chemModelRelay.updateView();
    }

    private void doZoom(double z) {
        IRenderer renderer = this.chemModelRelay.getRenderer();
        Point2d screenCoord = renderer.toScreenCoordinates(this.worldCoord.x, this.worldCoord.y);
        this.zoom(z);
        Point2d newScreenCoords = renderer.toScreenCoordinates(this.worldCoord.x, this.worldCoord.y);
        Vector2d v = new Vector2d();
        v.sub(screenCoord, newScreenCoords);
        renderer.shiftDrawCenter(v.x, v.y);
    }

    private void zoom(double zoomFactor) {
        RendererModel model = this.chemModelRelay.getRenderer().getRenderer2DModel();
        double zoom = (Double)model.getParameter(BasicSceneGenerator.ZoomFactor.class).getValue();
        if ((zoom *= zoomFactor) < 0.1 && zoom > 100.0) {
            return;
        }
        this.chemModelRelay.getRenderer().setZoom(zoom);
    }

    @Override
    public void mouseMove(Point2d worldCoord) {
        this.worldCoord = worldCoord;
    }

    @Override
    public String getDrawModeString() {
        return "Zoom";
    }
}

