/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import javax.vecmath.Point2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.HighlightAtomGenerator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class AtomAtomMappingModule
extends ControllerModuleAdapter {
    private IAtom startAtom;

    public AtomAtomMappingModule(IChemModelRelay chemModelRelay) {
        super(chemModelRelay);
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        RendererModel model = this.chemModelRelay.getRenderer().getRenderer2DModel();
        double dH = (Double)model.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        IAtom closestAtom = this.chemModelRelay.getClosestAtom(worldCoord);
        this.startAtom = closestAtom == null || closestAtom.getPoint2d().distance(worldCoord) > dH ? null : this.chemModelRelay.getClosestAtom(worldCoord);
    }

    @Override
    public void mouseClickedUp(Point2d worldCoord) {
        RendererModel model = this.chemModelRelay.getRenderer().getRenderer2DModel();
        double dH = (Double)model.getParameter(HighlightAtomGenerator.HighlightAtomDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        IAtom closestAtom = this.chemModelRelay.getClosestAtom(worldCoord);
        IAtom endAtom = null;
        if (closestAtom != null && closestAtom.getPoint2d().distance(worldCoord) < dH) {
            endAtom = this.chemModelRelay.getClosestAtom(worldCoord);
        }
        if (endAtom != null && this.startAtom != null) {
            IMapping mapping = (IMapping)this.startAtom.getBuilder().newInstance(IMapping.class, new Object[]{this.startAtom, endAtom});
            IReaction reaction1 = ChemModelManipulator.getRelevantReaction((IChemModel)this.chemModelRelay.getIChemModel(), (IAtom)this.startAtom);
            IReaction reaction2 = ChemModelManipulator.getRelevantReaction((IChemModel)this.chemModelRelay.getIChemModel(), (IAtom)endAtom);
            if (reaction1 != null && reaction2 != null && reaction1 == reaction2) {
                reaction1.addMapping(mapping);
            }
        }
        this.startAtom = null;
    }

    @Override
    public void setChemModelRelay(IChemModelRelay relay) {
        this.chemModelRelay = relay;
    }

    @Override
    public String getDrawModeString() {
        return "Do Atom-Atom Mapping";
    }
}

