/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.log4j.Logger;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealSquareMatrix;
import org.xmlcml.euclid.Vector2;
import org.xmlcml.euclid.Window2;

public class Transform2
extends RealSquareMatrix {
    static final Logger logger = Logger.getLogger(Transform2.class.getName());
    Type trnsfrm;

    public Transform2() {
        super(3);
        for (int i = 0; i < 3; ++i) {
            this.flmat[i][i] = 1.0;
        }
        this.trnsfrm = Type.ANY;
    }

    public Transform2(Type t) {
        this();
        this.trnsfrm = t;
    }

    public Transform2(Vector2 v) {
        this();
        this.trnsfrm = Type.ROT_TRANS;
        this.flmat[0][2] = v.x;
        this.flmat[1][2] = v.y;
    }

    public Transform2(Angle zrot) {
        this();
        double cosx = zrot.cos();
        double sinx = zrot.sin();
        this.flmat[0][0] = cosx;
        this.flmat[0][1] = sinx;
        this.flmat[1][0] = -sinx;
        this.flmat[1][1] = cosx;
        this.flmat[2][2] = 1.0;
        this.trnsfrm = Type.ROT_ORIG;
    }

    public Transform2(Transform2 t, Real2 p) {
        super(3);
        this.flmat[0][2] = -t.flmat[0][0] * p.x - t.flmat[0][1] * p.y + p.x;
        this.flmat[1][2] = -t.flmat[1][0] * p.x - t.flmat[1][1] * p.y + p.y;
        this.flmat[0][0] = t.flmat[0][0];
        this.flmat[0][1] = t.flmat[0][1];
        this.flmat[1][0] = t.flmat[1][0];
        this.flmat[1][1] = t.flmat[1][1];
        this.trnsfrm = Type.ROT_TRANS;
    }

    public Transform2(Vector2 v1, Vector2 v2) throws EuclidRuntimeException {
        super(3);
        Angle a = v1.getAngleMadeWith(v2);
        Transform2 temp = new Transform2(a);
        this.flmat = temp.flmat;
        this.trnsfrm = temp.trnsfrm;
    }

    public Transform2(Real2 v1, Real2 v2) {
        super(3);
        for (int i = 0; i < 2; ++i) {
            this.flmat[0][0] = v1.x;
            this.flmat[1][0] = v2.x;
            this.flmat[0][1] = v1.y;
            this.flmat[1][1] = v2.y;
            this.flmat[2][i] = 0.0;
            this.flmat[i][2] = 0.0;
        }
        this.flmat[2][2] = 1.0;
        this.trnsfrm = Type.ROT_ORIG;
    }

    public Transform2(double[] array) throws EuclidRuntimeException {
        super(3, array);
        this.trnsfrm = this.calculateMatrixType();
    }

    public Transform2(Transform2 m) {
        super(m);
        this.trnsfrm = m.trnsfrm;
    }

    public Transform2(RealSquareMatrix m) throws EuclidRuntimeException {
        this();
        if (m.getCols() == 2) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.flmat[i][j] = m.flmat[i][j];
                }
            }
        } else {
            if (m.getCols() != 3) {
                throw new EuclidRuntimeException("bad size for transform " + m.getCols());
            }
            this.flmat = m.flmat;
        }
        this.trnsfrm = this.calculateMatrixType();
    }

    public Transform2(RealSquareMatrix m, Vector2 v) throws EuclidRuntimeException {
        this(m);
        if (m.getCols() != 2) {
            throw new EuclidRuntimeException("must have 2*2 rotation matrix");
        }
        this.flmat[0][2] = v.x;
        this.flmat[1][2] = v.y;
    }

    public Transform2 clone(Transform2 m) {
        Transform2 temp = new Transform2((RealSquareMatrix)m);
        temp.trnsfrm = m.trnsfrm;
        return temp;
    }

    public Transform2(Window2 in, Window2 out, boolean keepAspectRatio) throws ArithmeticException {
        this(in.origin, in.dim, out.origin, out.dim, keepAspectRatio);
    }

    public Transform2(Real2 originIn, Real2 dimensionIn, Real2 originOut, Real2 dimensionOut, boolean keepAspectRatio) throws ArithmeticException {
        this();
        double scaleX = dimensionOut.getX() / dimensionIn.getX();
        double scaleY = dimensionOut.getY() / dimensionIn.getY();
        if (keepAspectRatio) {
            if (Math.abs(scaleX) < Math.abs(scaleY)) {
                scaleY = scaleX * (scaleY / Math.abs(scaleY));
            }
            if (Math.abs(scaleY) < Math.abs(scaleX)) {
                scaleX = scaleY * (scaleX / Math.abs(scaleX));
            }
        }
        this.flmat[0][0] = scaleX;
        this.flmat[1][1] = scaleY;
        this.flmat[0][2] = originOut.getX() - scaleX * originIn.getX();
        this.flmat[1][2] = originOut.getY() - scaleY * originIn.getY();
    }

    Transform2 clone(RealSquareMatrix m) {
        Transform2 temp = new Transform2(m);
        temp.trnsfrm = this.calculateMatrixType();
        return temp;
    }

    public boolean isEqualTo(Transform2 m) {
        return super.isEqualTo(m) && this.trnsfrm == m.trnsfrm;
    }

    public static Transform2 getRotationAboutPoint(Angle angle, Real2 point) {
        Transform2 t3 = new Transform2(new Vector2(point));
        Transform2 t2 = new Transform2(angle);
        Transform2 t1 = new Transform2(new Vector2(point.multiplyBy(-1.0)));
        return t3.concatenate(t2).concatenate(t1);
    }

    public Transform2 concatenate(Transform2 m2) {
        RealSquareMatrix temp = new RealSquareMatrix(this.multiply(m2));
        Transform2 temp1 = new Transform2(temp);
        temp1.trnsfrm = this.trnsfrm.i > m2.trnsfrm.i ? this.trnsfrm : m2.trnsfrm;
        return temp1;
    }

    public int setTransformationType(Type option) {
        RealSquareMatrix s3 = new RealSquareMatrix();
        if (option == Type.ROT_ORIG) {
            s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 1, 0, 1));
            s3.orthonormalize();
            this.replaceSubMatrixData(0, 0, s3);
        } else if (option == Type.ROT_TRANS) {
            s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 1, 0, 1));
            s3.orthonormalize();
            this.replaceSubMatrixData(0, 0, s3);
        } else if (option == Type.ROT_TRANS_SCALE) {
            s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 1, 0, 1));
            double[] scale = s3.euclideanColumnLengths().getArray();
            double scale3 = Math.exp(Math.log(scale[0] * scale[1]) / 2.0);
            s3.orthonormalize();
            RealArray sc1 = new RealArray(3, scale3);
            RealSquareMatrix s = RealSquareMatrix.diagonal(sc1);
            s3 = s.multiply(s3);
            this.replaceSubMatrixData(0, 0, s3);
        } else if (option != Type.ROT_TRANS_SCALE_PERSP) {
            if (option == Type.ROT_TRANS_AXIAL_SCALE) {
                s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 1, 0, 1));
                RealArray scale = s3.euclideanColumnLengths();
                s3.orthonormalize();
                RealSquareMatrix s = RealSquareMatrix.diagonal(scale);
                s3 = s.multiply(s3);
                this.replaceSubMatrixData(0, 0, s3);
            } else if (option != Type.ANY && option != Type.NULL) {
                return 1;
            }
        }
        this.trnsfrm = option;
        return 0;
    }

    public Type getTransformationType() {
        return this.trnsfrm;
    }

    public Type calculateMatrixType() {
        RealSquareMatrix s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 1, 0, 1));
        RealArray c3 = this.extractColumnData(2);
        if (c3 != null && Real.isZero(c3.elementAt(0), Real.getEpsilon()) && Real.isZero(c3.elementAt(1), Real.getEpsilon())) {
            return Type.NULL;
        }
        if (s3.isUnit()) {
            return Type.NULL;
        }
        if (s3.isUnitary()) {
            return Type.ROT_ORIG;
        }
        if (s3.isUnitary()) {
            return Type.ROT_TRANS;
        }
        if (s3.isOrthogonal()) {
            double[] scale = s3.euclideanColumnLengths().getArray();
            if (Real.isEqual(scale[0], scale[1])) {
                return Type.ROT_TRANS_SCALE;
            }
            return Type.ROT_TRANS_AXIAL_SCALE;
        }
        return Type.ANY;
    }

    public Angle getAngleOfRotation() {
        return new Angle(Math.atan2(this.flmat[0][1], this.flmat[0][0]));
    }

    public static Transform2 flipAboutVector(Real2 r) throws EuclidRuntimeException {
        r = r.getUnitVector();
        double cost = r.x;
        double sint = r.y;
        Transform2 temp = new Transform2();
        temp.flmat[0][0] = cost * cost - sint * sint;
        temp.flmat[1][1] = -temp.flmat[0][0];
        double d = 2.0 * cost * sint;
        temp.flmat[1][0] = d;
        temp.flmat[0][1] = d;
        return temp;
    }

    public Real2 getTranslation() {
        return new Real2(this.flmat[0][2], this.flmat[1][2]);
    }

    RealArray getScales() {
        RealSquareMatrix s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 1, 0, 1));
        RealArray scales = s3.euclideanColumnLengths();
        return scales;
    }

    public RealSquareMatrix getRotationMatrix() {
        RealSquareMatrix s3 = new RealSquareMatrix(this.extractSubMatrixData(0, 1, 0, 1));
        s3.normaliseByColumns();
        RealSquareMatrix s = s3;
        return s;
    }

    public static Transform2 getTransformToRotateAndStretchLine(Real2 pivotPoint, Real2 movingPoint, Real2 targetPoint) {
        Vector2 pivotVector = new Vector2(movingPoint.subtract(pivotPoint));
        Vector2 targetVector = new Vector2(targetPoint.subtract(pivotPoint));
        Angle angle = pivotVector.getAngleMadeWith(targetVector);
        Transform2 rotate = new Transform2(angle);
        Transform2 rotateAboutOtherPoint = new Transform2(rotate, pivotPoint);
        Vector2 deltaVector = new Vector2(targetVector.subtract(pivotVector));
        Vector2 stretchVector = deltaVector.projectOnto(pivotVector);
        Transform2 stretch = new Transform2(stretchVector);
        Transform2 finalTransform = rotateAboutOtherPoint.concatenate(stretch);
        return finalTransform;
    }

    public String toString() {
        String s = "(";
        for (int i = 0; i < this.flmat.length; ++i) {
            for (int j = 0; j < this.flmat[i].length; ++j) {
                s = s + this.flmat[i][j];
                s = s + ",";
            }
            if (i >= this.flmat.length - 1) continue;
            s = s + "\n";
        }
        s = s + ")";
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NULL(1, "none"),
        ROT_ORIG(2, "rotation about origin"),
        ROT_TRANS(3, "rotation translation"),
        ROT_TRANS_SCALE(4, "rotation translation scale"),
        ROT_TRANS_AXIAL_SCALE(5, "rotation translation axial scale"),
        ROT_TRANS_SCALE_PERSP(6, "perspective"),
        ANY(7, "any");

        public int i;
        public String s;

        private Type(int i, String s) {
            this.i = i;
            this.s = s;
        }
    }
}

