/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.Element;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

@TestClass(value="org.openscience.cdk.tools.DeAromatizationToolTest")
public class DeAromatizationTool {
    @TestMethod(value="testDeAromatize_IRing,testPyridine,testBezene")
    public static boolean deAromatize(IRing ring) {
        int i;
        boolean allaromatic = true;
        for (i = 0; i < ring.getBondCount(); ++i) {
            if (ring.getBond(i).getFlag(5)) continue;
            allaromatic = false;
        }
        if (!allaromatic) {
            return false;
        }
        for (i = 0; i < ring.getBondCount(); ++i) {
            if (!ring.getBond(i).getFlag(5)) continue;
            ring.getBond(i).setOrder(IBond.Order.SINGLE);
        }
        boolean result = false;
        IMolecularFormula formula = MolecularFormulaManipulator.getMolecularFormula(ring);
        if (ring.getRingSize() == 6) {
            if (MolecularFormulaManipulator.getElementCount(formula, new Element("C")) == 6) {
                result = DeAromatizationTool.deAromatizeBenzene(ring);
            } else if (MolecularFormulaManipulator.getElementCount(formula, new Element("C")) == 5 && MolecularFormulaManipulator.getElementCount(formula, new Element("N")) == 1) {
                result = DeAromatizationTool.deAromatizePyridine(ring);
            }
        }
        if (ring.getRingSize() == 5 && MolecularFormulaManipulator.getElementCount(formula, new Element("C")) == 4 && MolecularFormulaManipulator.getElementCount(formula, new Element("N")) == 1) {
            result = DeAromatizationTool.deAromatizePyrolle(ring);
        }
        return result;
    }

    private static boolean deAromatizePyridine(IRing ring) {
        return DeAromatizationTool.deAromatizeBenzene(ring);
    }

    private static boolean deAromatizePyrolle(IRing ring) {
        if (ring.getBondCount() != 5) {
            return false;
        }
        for (int i = 0; i < ring.getAtomCount(); ++i) {
            IAtom atom = ring.getAtom(i);
            if (!atom.getSymbol().equals("N")) continue;
            int done = 0;
            IBond bond = null;
            int count = 0;
            while (done != 2) {
                atom = (bond = DeAromatizationTool.getNextBond(atom, bond, ring)).getAtom(0) == atom ? bond.getAtom(1) : bond.getAtom(0);
                if (++count % 2 != 0) continue;
                bond.setOrder(IBond.Order.DOUBLE);
                ++done;
            }
            break;
        }
        return true;
    }

    private static IBond getNextBond(IAtom atom, IBond bond, IRing ring) {
        List<IBond> bonds = ring.getConnectedBondsList(atom);
        for (int i = 0; i < bonds.size(); ++i) {
            if (bonds.get(i) == bond) continue;
            return bonds.get(i);
        }
        return null;
    }

    private static boolean deAromatizeBenzene(IRing ring) {
        if (ring.getBondCount() != 6) {
            return false;
        }
        int counter = 0;
        for (IBond bond : ring.bonds()) {
            if (counter % 2 == 0) {
                bond.setOrder(CDKConstants.BONDORDER_SINGLE);
            } else {
                bond.setOrder(CDKConstants.BONDORDER_DOUBLE);
            }
            ++counter;
        }
        return true;
    }
}

