/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.libio.cml;

import nu.xom.Attribute;
import nu.xom.Element;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.libio.cml.ICMLCustomizer;
import org.openscience.cdk.protein.data.PDBAtom;
import org.xmlcml.cml.element.AbstractScalar;
import org.xmlcml.cml.element.CMLScalar;

public class PDBAtomCustomizer
implements ICMLCustomizer {
    @Override
    public void customize(IAtom atom, Object nodeToAdd) throws Exception {
        if (!(nodeToAdd instanceof Element)) {
            throw new CDKException("NodeToAdd must be of type nu.xom.Element!");
        }
        Element element = (Element)nodeToAdd;
        if (atom instanceof PDBAtom) {
            Element scalar;
            PDBAtom pdbAtom = (PDBAtom)atom;
            if (pdbAtom.getAltLoc() != null) {
                scalar = new CMLScalar();
                ((AbstractScalar)scalar).addAttribute(new Attribute("dictRef", "pdb:altLoc"));
                scalar.appendChild(pdbAtom.getAltLoc());
                element.appendChild(scalar);
            }
            if (pdbAtom.getChainID() != null) {
                scalar = new CMLScalar();
                scalar.addAttribute(new Attribute("dictRef", "pdb:chainID"));
                scalar.appendChild(pdbAtom.getChainID());
                element.appendChild(scalar);
            }
            scalar = new CMLScalar();
            scalar.addAttribute(new Attribute("dictRef", "pdb:hetAtom"));
            scalar.appendChild("" + pdbAtom.getHetAtom());
            element.appendChild(scalar);
            if (pdbAtom.getICode() != null) {
                scalar = new CMLScalar();
                scalar.addAttribute(new Attribute("dictRef", "pdb:iCode"));
                scalar.appendChild(pdbAtom.getICode());
                element.appendChild(scalar);
            }
            if (pdbAtom.getName() != null) {
                scalar = new Element("label");
                scalar.addAttribute(new Attribute("dictRef", "pdb:name"));
                scalar.appendChild(pdbAtom.getName());
                element.appendChild(scalar);
            }
            scalar = new CMLScalar();
            scalar.addAttribute(new Attribute("dictRef", "pdb:oxt"));
            scalar.appendChild("" + pdbAtom.getOxt());
            element.appendChild(scalar);
            if (pdbAtom.getRecord() != null) {
                scalar = new CMLScalar();
                scalar.addAttribute(new Attribute("dictRef", "pdb:record"));
                scalar.appendChild(pdbAtom.getRecord());
                element.appendChild(scalar);
            }
            if (pdbAtom.getResName() != null) {
                scalar = new CMLScalar();
                scalar.addAttribute(new Attribute("dictRef", "pdb:resName"));
                scalar.appendChild(pdbAtom.getResName());
                element.appendChild(scalar);
            }
            if (pdbAtom.getResSeq() != null) {
                scalar = new CMLScalar();
                scalar.addAttribute(new Attribute("dictRef", "pdb:resSeq"));
                scalar.appendChild(pdbAtom.getResSeq());
                element.appendChild(scalar);
            }
            if (pdbAtom.getSegID() != null) {
                scalar = new CMLScalar();
                scalar.addAttribute(new Attribute("dictRef", "pdb:segID"));
                scalar.appendChild(pdbAtom.getSegID());
                element.appendChild(scalar);
            }
            if (pdbAtom.getSerial() != 0) {
                scalar = new CMLScalar();
                scalar.addAttribute(new Attribute("dictRef", "pdb:serial"));
                scalar.appendChild("" + pdbAtom.getSerial());
                element.appendChild(scalar);
            }
            if (pdbAtom.getTempFactor() != -1.0) {
                scalar = new CMLScalar();
                scalar.addAttribute(new Attribute("dictRef", "pdb:tempFactor"));
                scalar.appendChild("" + pdbAtom.getTempFactor());
                element.appendChild(scalar);
            }
            element.addAttribute(new Attribute("occupancy", "" + pdbAtom.getOccupancy()));
        }
    }

    @Override
    public void customize(IAtomContainer molecule, Object nodeToAdd) throws Exception {
    }

    @Override
    public void customize(IBond bond, Object nodeToAdd) throws Exception {
    }
}

