/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.guha.rcdk.view.panels.MoleculeCell;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.smiles.SmilesParser;

public class MoleculeDisplay
extends JPanel {
    int ncol = 2;
    int nrow = 2;
    int sep = 2;
    int width = 200;
    int height = 200;
    int nmol = 0;
    GridLayout layout = new GridLayout(this.nrow, this.ncol, this.sep, this.sep);

    public MoleculeDisplay() {
        this.setLayout(this.layout);
    }

    public void setParams(String paramString) throws CDKException {
        this.parseParamString(paramString);
    }

    private void parseParamString(String paramString) throws CDKException {
        String[] lines;
        for (String s : lines = paramString.split("\n")) {
            String[] toks = s.split("=");
            if (toks.length != 2) {
                throw new CDKException("Invalid parameter string");
            }
            String varName = toks[0].trim();
            String varValue = toks[1].trim();
            if (varName.equals("ncol")) {
                this.ncol = Integer.parseInt(varValue);
                continue;
            }
            if (varName.equals("nrow")) {
                this.nrow = Integer.parseInt(varValue);
                continue;
            }
            if (varName.equals("sep")) {
                this.sep = Integer.parseInt(varValue);
                continue;
            }
            if (varName.equals("width")) {
                this.width = Integer.parseInt(varValue);
                continue;
            }
            if (!varName.equals("height")) continue;
            this.height = Integer.parseInt(varValue);
        }
        this.layout = new GridLayout(this.nrow, this.ncol, this.sep, this.sep);
    }

    public void addMolecule(IAtomContainer molecule) {
        MoleculeCell cell = new MoleculeCell(molecule, this.width, this.height);
        this.add(cell);
    }

    public void addLabel(String label) {
        this.add(new JLabel(label));
    }

    public int getMoleculeCount() {
        return this.nmol;
    }

    public static void main(String[] args) throws CDKException {
        MoleculeDisplay md = new MoleculeDisplay();
        SmilesParser sp = new SmilesParser((IChemObjectBuilder)DefaultChemObjectBuilder.getInstance());
        String[] smiles = new String[]{"CCC", "c1ccccc1COC", "C12CN(CN(CCN(C1)Cc1ccccn1)CC2)C"};
        ArrayList<IMolecule> mols = new ArrayList<IMolecule>();
        for (String s : smiles) {
            IMolecule mol = sp.parseSmiles(s);
            StructureDiagramGenerator sdg = new StructureDiagramGenerator();
            sdg.setMolecule(mol);
            try {
                sdg.generateCoordinates();
            }
            catch (Exception e) {
                // empty catch block
            }
            mol = sdg.getMolecule();
            mols.add(mol);
        }
        md.addMolecule((IAtomContainer)mols.get(0));
        md.addMolecule((IAtomContainer)mols.get(1));
        md.addLabel("Foo");
        md.addLabel("Bar");
        JFrame f = new JFrame("Molecule Display");
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(md);
        f.pack();
        f.setVisible(true);
    }
}

