/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.dialogs.ValidateFrame;
import org.openscience.cdk.atomtype.MM2AtomTypeMatcher;
import org.openscience.cdk.atomtype.MMFF94AtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class PerceiveAtomTypesAction
extends JCPAction {
    private static final long serialVersionUID = -3776589605934024224L;
    ValidateFrame frame = null;

    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)"detected force field type list: ", (Object)this.type);
        MM2AtomTypeMatcher matcher = null;
        if ("mm2".equals(this.type)) {
            matcher = new MM2AtomTypeMatcher();
        } else if ("mmff94".equals(this.type)) {
            matcher = new MMFF94AtomTypeMatcher();
        }
        if (matcher == null) {
            logger.warn((Object)("Not a known atom type list: " + this.type));
            return;
        }
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        IChemModel model = jcpmodel.getChemModel();
        Iterator containers = ChemModelManipulator.getAllAtomContainers((IChemModel)model).iterator();
        while (containers.hasNext()) {
            IAtomContainer container = (IAtomContainer)containers.next();
            Iterator atoms = container.atoms();
            while (atoms.hasNext()) {
                IAtom atom = (IAtom)atoms.next();
                try {
                    atom.setAtomTypeName(matcher.findMatchingAtomType(container, atom).getAtomTypeName());
                }
                catch (CDKException e) {
                    logger.error((Object)"Could not find atom type name for atom!", (Object)e);
                    logger.debug((Object)e);
                }
            }
        }
    }
}

