/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JFrame;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.dialogs.TextViewDialog;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.layout.HydrogenPlacer;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.HydrogenAdder;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class CreateSmilesAction
extends JCPAction {
    private static final long serialVersionUID = -4886982931009753342L;
    TextViewDialog dialog = null;
    JFrame frame = null;

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)"Trying to create smile: ", (Object)this.type);
        if (this.dialog == null) {
            this.dialog = new TextViewDialog(this.frame, "SMILES", null, false, 40, 2);
        }
        String smiles = "";
        String chiralsmiles = "";
        try {
            ChemModel model = (ChemModel)this.jcpPanel.getJChemPaintModel().getChemModel();
            SmilesGenerator generator = new SmilesGenerator();
            IAtomContainer container = ChemModelManipulator.getAllInOneContainer((IChemModel)model);
            Molecule molecule = new Molecule(container);
            Molecule moleculewithh = (Molecule)molecule.clone();
            new HydrogenAdder().addExplicitHydrogensToSatisfyValency((IAtomContainer)moleculewithh);
            double bondLength = GeometryTools.getBondLengthAverage((IAtomContainer)container, (HashMap)this.jcpPanel.getJChemPaintModel().getRendererModel().getRenderingCoordinates());
            new HydrogenPlacer().placeHydrogens2D((IAtomContainer)moleculewithh, bondLength);
            smiles = generator.createSMILES((IMolecule)molecule);
            boolean[] bool = new boolean[moleculewithh.getBondCount()];
            SmilesGenerator sg = new SmilesGenerator();
            for (int i = 0; i < bool.length; ++i) {
                if (!sg.isValidDoubleBondConfiguration((IAtomContainer)moleculewithh, moleculewithh.getBond(i))) continue;
                bool[i] = true;
            }
            chiralsmiles = generator.createChiralSMILES((IMolecule)moleculewithh, bool);
            this.dialog.setMessage("Generated SMILES:", "SMILES: " + smiles + System.getProperty("line.separator") + "chiral SMILES: " + chiralsmiles);
        }
        catch (Exception exception) {
            String message = "Error while creating SMILES: " + exception.getMessage();
            logger.error((Object)message);
            logger.debug((Object)exception);
            this.dialog.setMessage("Error", message);
        }
        this.dialog.show();
    }
}

