/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import org.openscience.cdk.Atom;
import org.openscience.cdk.EnzymeResidueLocator;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class ConvertToAction
extends JCPAction {
    private static final long serialVersionUID = 4239327873015560552L;

    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)"Converting to: ", (Object)this.type);
        IChemObject object = this.getSource(event);
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        IChemModel model = jcpmodel.getChemModel();
        if (object != null) {
            if (object instanceof Atom) {
                if (this.type.equals("atomToPseudoAtom")) {
                    Atom atom = (Atom)object;
                    IAtomContainer relevantContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)model, (IAtom)atom);
                    AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)relevantContainer, (IAtom)atom, (IAtom)new PseudoAtom((IElement)atom));
                } else if (this.type.equals("atomToEnzymeResidueLocator")) {
                    Atom atom = (Atom)object;
                    IAtomContainer relevantContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)model, (IAtom)atom);
                    AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)relevantContainer, (IAtom)atom, (IAtom)new EnzymeResidueLocator(atom));
                } else {
                    logger.error((Object)"Unknown convertTo type!");
                }
            } else {
                logger.error((Object)"Object not an Atom! Cannot convert into a PseudoAtom!");
            }
        } else {
            logger.warn((Object)"Cannot convert a null object!");
        }
        jcpmodel.fireChange();
    }
}

