/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Monomer;

class PhosphorusMonomer
extends Monomer {
    static final byte[] phosphorusOffsets = new byte[]{0};

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex, int[] specialAtomIndexes, Atom[] atoms) {
        if (firstIndex != lastIndex || specialAtomIndexes[12] != firstIndex) {
            return null;
        }
        return new PhosphorusMonomer(chain, group3, seqcode, firstIndex, lastIndex, phosphorusOffsets);
    }

    PhosphorusMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
    }

    boolean isPhosphorusMonomer() {
        return true;
    }

    byte getProteinStructureType() {
        return 0;
    }

    Atom getAtom(byte specialAtomID) {
        return specialAtomID == 12 ? this.getLeadAtom() : null;
    }

    Point3f getAtomPoint(byte specialAtomID) {
        return specialAtomID == 12 ? this.getLeadAtomPoint() : null;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        if (!(possiblyPreviousMonomer instanceof PhosphorusMonomer)) {
            return false;
        }
        float distance = this.getLeadAtomPoint().distance(possiblyPreviousMonomer.getLeadAtomPoint());
        return distance <= 7.1f;
    }
}

