/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMolecule;

public class SmilesParser {
    private SmilesBond[] ringBonds = null;

    public SmilesMolecule parseSmiles(String smiles) throws InvalidSmilesException {
        int i;
        if (smiles == null) {
            throw new InvalidSmilesException("SMILES expressions must not be null");
        }
        SmilesMolecule molecule = new SmilesMolecule();
        this.parseSmiles(molecule, smiles, null);
        for (i = 0; i < molecule.getAtomsCount(); ++i) {
            SmilesAtom atom = molecule.getAtom(i);
            atom.createMissingHydrogen(molecule);
        }
        if (this.ringBonds != null) {
            for (i = 0; i < this.ringBonds.length; ++i) {
                if (this.ringBonds[i] == null) continue;
                throw new InvalidSmilesException("Open ring");
            }
        }
        return molecule;
    }

    private void parseSmiles(SmilesMolecule molecule, String smiles, SmilesAtom currentAtom) throws InvalidSmilesException {
        int currentIndex;
        int bondType;
        String subSmiles;
        if (smiles == null || smiles.length() == 0) {
            return;
        }
        int index = 0;
        char firstChar = smiles.charAt(index);
        if (firstChar == '(') {
            int currentIndex2;
            int parenthesisCount = 1;
            block4: for (currentIndex2 = ++index; currentIndex2 < smiles.length() && parenthesisCount > 0; ++currentIndex2) {
                switch (smiles.charAt(currentIndex2)) {
                    case '(': {
                        ++parenthesisCount;
                        continue block4;
                    }
                    case ')': {
                        --parenthesisCount;
                    }
                }
            }
            if (parenthesisCount != 0) {
                throw new InvalidSmilesException("Unbalanced parenthesis");
            }
            subSmiles = smiles.substring(index, currentIndex2 - 1);
            this.parseSmiles(molecule, subSmiles, currentAtom);
            index = currentIndex2;
            if (index >= smiles.length()) {
                throw new InvalidSmilesException("Pattern must not end with ')'");
            }
        }
        if ((bondType = SmilesBond.getBondTypeFromCode(firstChar = smiles.charAt(index))) != -1) {
            if (currentAtom == null) {
                throw new InvalidSmilesException("Bond without a previous atom");
            }
            ++index;
        }
        if ((firstChar = smiles.charAt(index)) >= '0' && firstChar <= '9') {
            String subSmiles2 = smiles.substring(index, index + 1);
            this.parseRing(molecule, subSmiles2, currentAtom, bondType);
            ++index;
        } else if (firstChar == '%') {
            if (smiles.charAt(++index) < '\u0000' || smiles.charAt(index) > '\t') {
                throw new InvalidSmilesException("Ring number must follow the % sign");
            }
            for (currentIndex = index; currentIndex < smiles.length() && smiles.charAt(currentIndex) >= '0' && smiles.charAt(currentIndex) <= '9'; ++currentIndex) {
            }
            subSmiles = smiles.substring(index, currentIndex);
            this.parseRing(molecule, subSmiles, currentAtom, bondType);
            index = currentIndex;
        } else if (firstChar == '[') {
            for (currentIndex = ++index; currentIndex < smiles.length() && smiles.charAt(currentIndex) != ']'; ++currentIndex) {
            }
            if (currentIndex >= smiles.length()) {
                throw new InvalidSmilesException("Unmatched [");
            }
            subSmiles = smiles.substring(index, currentIndex);
            currentAtom = this.parseAtom(molecule, subSmiles, currentAtom, bondType, true);
            index = currentIndex + 1;
        } else if (firstChar >= 'a' && firstChar <= 'z' || firstChar >= 'A' && firstChar <= 'Z' || firstChar == '*') {
            int size = 1;
            if (index + 1 < smiles.length()) {
                char secondChar = smiles.charAt(index + 1);
                if (firstChar >= 'A' && firstChar <= 'Z' && secondChar >= 'a' && secondChar <= 'z') {
                    size = 2;
                }
            }
            subSmiles = smiles.substring(index, index + size);
            currentAtom = this.parseAtom(molecule, subSmiles, currentAtom, bondType, false);
            index += size;
        }
        if (index == 0) {
            throw new InvalidSmilesException("Unexpected character: " + smiles.charAt(0));
        }
        if (index < smiles.length()) {
            String subSmiles3 = smiles.substring(index);
            this.parseSmiles(molecule, subSmiles3, currentAtom);
        }
    }

    private SmilesAtom parseAtom(SmilesMolecule molecule, String smiles, SmilesAtom currentAtom, int bondType, boolean complete) throws InvalidSmilesException {
        String sub;
        int currentIndex;
        if (smiles == null || smiles.length() == 0) {
            throw new InvalidSmilesException("Empty atom definition");
        }
        int index = 0;
        char firstChar = smiles.charAt(index);
        int atomicMass = Integer.MIN_VALUE;
        if (firstChar >= '0' && firstChar <= '9') {
            int currentIndex2;
            for (currentIndex2 = index; currentIndex2 < smiles.length() && smiles.charAt(currentIndex2) >= '0' && smiles.charAt(currentIndex2) <= '9'; ++currentIndex2) {
            }
            String sub2 = smiles.substring(index, currentIndex2);
            try {
                atomicMass = Integer.parseInt(sub2);
            }
            catch (NumberFormatException e) {
                throw new InvalidSmilesException("Non numeric atomic mass");
            }
            index = currentIndex2;
        }
        if (index >= smiles.length()) {
            throw new InvalidSmilesException("Missing atom symbol");
        }
        firstChar = smiles.charAt(index);
        if (!(firstChar >= 'a' && firstChar <= 'z' || firstChar >= 'A' && firstChar <= 'Z' || firstChar == '*')) {
            throw new InvalidSmilesException("Unexpected atom symbol");
        }
        int size = 1;
        if (index + 1 < smiles.length()) {
            char secondChar = smiles.charAt(index + 1);
            if (firstChar >= 'A' && firstChar <= 'Z' && secondChar >= 'a' && secondChar <= 'z') {
                size = 2;
            }
        }
        String atomSymbol = smiles.substring(index, index + size);
        String chiralClass = null;
        int chiralOrder = Integer.MIN_VALUE;
        if ((index += size) < smiles.length() && (firstChar = smiles.charAt(index)) == '@') {
            if (++index < smiles.length()) {
                firstChar = smiles.charAt(index);
                if (firstChar == '@') {
                    ++index;
                    chiralClass = "";
                    chiralOrder = 2;
                } else if (firstChar >= 'A' && firstChar <= 'Z' && firstChar != 'H') {
                    char secondChar;
                    if (index + 1 < smiles.length() && (secondChar = smiles.charAt(index)) >= 'A' && secondChar <= 'Z') {
                        chiralClass = smiles.substring(index, index + 2);
                        for (currentIndex = index += 2; currentIndex < smiles.length() && smiles.charAt(currentIndex) >= '0' && smiles.charAt(currentIndex) <= '9'; ++currentIndex) {
                        }
                        if (currentIndex > index) {
                            sub = smiles.substring(index, currentIndex);
                            try {
                                chiralOrder = Integer.parseInt(sub);
                            }
                            catch (NumberFormatException e) {
                                throw new InvalidSmilesException("Non numeric chiral order");
                            }
                        } else {
                            chiralOrder = 1;
                        }
                        index = currentIndex;
                    }
                } else {
                    chiralClass = "";
                    chiralOrder = 1;
                }
            } else {
                chiralClass = "";
                chiralOrder = 1;
            }
        }
        int hydrogenCount = Integer.MIN_VALUE;
        if (index < smiles.length() && (firstChar = smiles.charAt(index)) == 'H') {
            for (currentIndex = ++index; currentIndex < smiles.length() && smiles.charAt(currentIndex) >= '0' && smiles.charAt(currentIndex) <= '9'; ++currentIndex) {
            }
            if (currentIndex > index) {
                sub = smiles.substring(index, currentIndex);
                try {
                    hydrogenCount = Integer.parseInt(sub);
                }
                catch (NumberFormatException e) {
                    throw new InvalidSmilesException("Non numeric hydrogen count");
                }
            } else {
                hydrogenCount = 1;
            }
            index = currentIndex;
        }
        if (hydrogenCount == Integer.MIN_VALUE && complete) {
            hydrogenCount = 0;
        }
        int charge = 0;
        if (index < smiles.length() && ((firstChar = smiles.charAt(index)) == '+' || firstChar == '-')) {
            int count = 1;
            if (++index < smiles.length()) {
                char nextChar = smiles.charAt(index);
                if (nextChar >= '0' && nextChar <= '9') {
                    int currentIndex3;
                    for (currentIndex3 = index; currentIndex3 < smiles.length() && smiles.charAt(currentIndex3) >= '0' && smiles.charAt(currentIndex3) <= '9'; ++currentIndex3) {
                    }
                    String sub3 = smiles.substring(index, currentIndex3);
                    try {
                        count = Integer.parseInt(sub3);
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidSmilesException("Non numeric charge");
                    }
                    index = currentIndex3;
                } else {
                    int currentIndex4 = index;
                    while (currentIndex4 < smiles.length() && smiles.charAt(currentIndex4) == firstChar) {
                        ++currentIndex4;
                        ++count;
                    }
                    index = currentIndex4;
                }
            }
            charge = firstChar == '+' ? count : -count;
        }
        if (index < smiles.length()) {
            throw new InvalidSmilesException("Unexpected characters after atom definition: " + smiles.substring(index));
        }
        if (bondType == -1) {
            bondType = 1;
        }
        SmilesAtom newAtom = molecule.createAtom();
        if (currentAtom != null && bondType != 0) {
            molecule.createBond(currentAtom, newAtom, bondType);
        }
        newAtom.setSymbol(atomSymbol);
        newAtom.setAtomicMass(atomicMass);
        newAtom.setCharge(charge);
        newAtom.setChiralClass(chiralClass);
        newAtom.setChiralOrder(chiralOrder);
        newAtom.setHydrogenCount(hydrogenCount);
        return newAtom;
    }

    private void parseRing(SmilesMolecule molecule, String smiles, SmilesAtom currentAtom, int bondType) throws InvalidSmilesException {
        int ringNum = 0;
        try {
            ringNum = Integer.parseInt(smiles);
        }
        catch (NumberFormatException e) {
            throw new InvalidSmilesException("Non numeric ring identifier");
        }
        if (this.ringBonds == null) {
            this.ringBonds = new SmilesBond[10];
            for (int i = 0; i < this.ringBonds.length; ++i) {
                this.ringBonds[i] = null;
            }
        }
        if (ringNum >= this.ringBonds.length) {
            int i;
            SmilesBond[] tmp = new SmilesBond[ringNum + 1];
            for (i = 0; i < this.ringBonds.length; ++i) {
                tmp[i] = this.ringBonds[i];
            }
            for (i = this.ringBonds.length; i < tmp.length; ++i) {
                tmp[i] = null;
            }
        }
        if (this.ringBonds[ringNum] == null) {
            this.ringBonds[ringNum] = molecule.createBond(currentAtom, null, bondType);
        } else {
            if (bondType == -1) {
                bondType = this.ringBonds[ringNum].getBondType();
                if (bondType == -1) {
                    bondType = 1;
                }
            } else if (this.ringBonds[ringNum].getBondType() != -1 && this.ringBonds[ringNum].getBondType() != bondType) {
                throw new InvalidSmilesException("Incoherent bond type for ring");
            }
            this.ringBonds[ringNum].setBondType(bondType);
            this.ringBonds[ringNum].setAtom2(currentAtom);
            currentAtom.addBond(this.ringBonds[ringNum]);
            this.ringBonds[ringNum] = null;
        }
    }
}

