% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{spweights}
\alias{spweights}
\title{Compute weights from distance matrix}
\usage{
spweights(distmat, h = NULL, kernel = "gaussian")
}
\arguments{
\item{distmat}{a symmetric matrix of inter-site distances (in km).}

\item{h}{parameter of the Gaussian distance decay function.}

\item{kernel}{indicates the type of weighting function, either 'fixed' or 'gaussian'. Default is 'gaussian'.}
}
\value{
An object of class spatialweights
}
\description{
Function for computing a matrix of gaussian or fixed weights from distance matrix
}
\details{
This function generates a weight matrix (required for the \code{\link{SPpermTest}}) function. When \code{kernel=="fixed"}, the weight \eqn{w_{ij}} between site \eqn{i} and \eqn{j} is equal to 1 when their interdistance \eqn{d_{ij}} is below \code{h}, and equal to 0 when  \eqn{d_{ij}>h}.When \code{kernel=="gaussian"}, the weight is calculated with formula exp(-d_{ij}^2/h^2).
}
\examples{
lon <- c(11.3426,0.1278,0.1218)
lat <- c(44.4949,51.5074,52.2053)
library(sp)
d <- spDists(x=cbind(lon,lat),y=cbind(lon,lat))
spweights(d,h=100)
spweights(d,h=100,kernel="fixed")
}
