% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvec.R
\name{canvec.load}
\alias{canvec.load}
\title{Load CanVec Data}
\usage{
canvec.load(ntsid, layerid, cachedir = NULL)
}
\arguments{
\item{ntsid}{One or more NTS References as generated by \code{nts()}}

\item{layerid}{A single layer id as listed in \code{canvec_layers$id}}

\item{cachedir}{Pass a specific cache directory in which files have been extracted.
Default value is that returned by \code{canvec.cachedir()}}
}
\value{
A sp::Spatial* object loaded from the given shapefile or a \code{list}
        of Spatial* objects if more than one directory is specified.
}
\description{
Load layerid for NTS reference(s) that were previously downloaded to cachedir.
}
\examples{
buildings <- canvec.load(nts("21h1"), "building")

}

