% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/canvec.R
\name{canvec.cleanup}
\alias{canvec.cleanup}
\title{Remove CanVec Data Files}
\usage{
canvec.cleanup(ntsid = NULL, cachedir = NULL, all = FALSE,
  keeparchives = FALSE, keepfolders = FALSE)
}
\arguments{
\item{ntsid}{One or more NTS References as generated by \code{nts()}}

\item{cachedir}{The same \code{cachedir} that was passed to \code{canvec.download()}}

\item{all}{Use \code{all=TRUE} to recursively delete the cache directory.}

\item{keeparchives}{Pass \code{TRUE} to keep .zip files downloaded by \code{canvec.download()}}

\item{keepfolders}{Pass \code{TRUE} to keep folders extracted by \code{canvec.download()}}
}
\description{
Deletes files downloaded by \code{canvec.download()}. Use \code{all=TRUE}
to remove the cache directory entirely.
}
\examples{
\donttest{
canvec.download(nts('21h1'))
canvec.cleanup(nts('21h1'))
#or
canvec.cleanup(all=TRUE)
}
}

